/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RecoveryPointSelection;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLegalHoldRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateLegalHoldRequest> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CreateLegalHoldRequest.getter(CreateLegalHoldRequest::title)).setter(CreateLegalHoldRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLegalHoldRequest.getter(CreateLegalHoldRequest::description)).setter(CreateLegalHoldRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateLegalHoldRequest.getter(CreateLegalHoldRequest::idempotencyToken)).setter(CreateLegalHoldRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<RecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecoveryPointSelection").getter(CreateLegalHoldRequest.getter(CreateLegalHoldRequest::recoveryPointSelection)).setter(CreateLegalHoldRequest.setter(Builder::recoveryPointSelection)).constructor(RecoveryPointSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLegalHoldRequest.getter(CreateLegalHoldRequest::tags)).setter(CreateLegalHoldRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, DESCRIPTION_FIELD, IDEMPOTENCY_TOKEN_FIELD, RECOVERY_POINT_SELECTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLegalHoldRequest.memberNameToFieldInitializer();
    private final String title;
    private final String description;
    private final String idempotencyToken;
    private final RecoveryPointSelection recoveryPointSelection;
    private final Map<String, String> tags;

    private CreateLegalHoldRequest(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.description = builder.description;
        this.idempotencyToken = builder.idempotencyToken;
        this.recoveryPointSelection = builder.recoveryPointSelection;
        this.tags = builder.tags;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final RecoveryPointSelection recoveryPointSelection() {
        return this.recoveryPointSelection;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLegalHoldRequest)) {
            return false;
        }
        CreateLegalHoldRequest other = (CreateLegalHoldRequest)((Object)obj);
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.recoveryPointSelection(), other.recoveryPointSelection()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLegalHoldRequest").add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("RecoveryPointSelection", (Object)this.recoveryPointSelection()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "RecoveryPointSelection": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointSelection()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("RecoveryPointSelection", RECOVERY_POINT_SELECTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLegalHoldRequest, T> g) {
        return obj -> g.apply((CreateLegalHoldRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String title;
        private String description;
        private String idempotencyToken;
        private RecoveryPointSelection recoveryPointSelection;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLegalHoldRequest model) {
            super(model);
            this.title(model.title);
            this.description(model.description);
            this.idempotencyToken(model.idempotencyToken);
            this.recoveryPointSelection(model.recoveryPointSelection);
            this.tags(model.tags);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final RecoveryPointSelection.Builder getRecoveryPointSelection() {
            return this.recoveryPointSelection != null ? this.recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLegalHoldRequest build() {
            return new CreateLegalHoldRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLegalHoldRequest> {
        public Builder title(String var1);

        public Builder description(String var1);

        public Builder idempotencyToken(String var1);

        public Builder recoveryPointSelection(RecoveryPointSelection var1);

        default public Builder recoveryPointSelection(Consumer<RecoveryPointSelection.Builder> recoveryPointSelection) {
            return this.recoveryPointSelection((RecoveryPointSelection)((RecoveryPointSelection.Builder)RecoveryPointSelection.builder().applyMutation(recoveryPointSelection)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

