/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VaultType {
    BACKUP_VAULT("BACKUP_VAULT"),
    LOGICALLY_AIR_GAPPED_BACKUP_VAULT("LOGICALLY_AIR_GAPPED_BACKUP_VAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VaultType> VALUE_MAP;
    private final String value;

    private VaultType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VaultType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VaultType> knownValues() {
        EnumSet<VaultType> knownValues = EnumSet.allOf(VaultType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VaultType.class, VaultType::toString);
    }
}

