/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;

public class ListRestoreJobSummariesPublisher
implements SdkPublisher<ListRestoreJobSummariesResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreJobSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreJobSummariesPublisher(BackupAsyncClient client, ListRestoreJobSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreJobSummariesPublisher(BackupAsyncClient client, ListRestoreJobSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreJobSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreJobSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRestoreJobSummariesResponseFetcher
    implements AsyncPageFetcher<ListRestoreJobSummariesResponse> {
        private ListRestoreJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreJobSummariesResponse> nextPage(ListRestoreJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobSummariesPublisher.this.client.listRestoreJobSummaries(ListRestoreJobSummariesPublisher.this.firstRequest);
            }
            return ListRestoreJobSummariesPublisher.this.client.listRestoreJobSummaries((ListRestoreJobSummariesRequest)((Object)ListRestoreJobSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

