/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.CopyJob;
import software.amazon.awssdk.services.backup.model.CopyJobsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCopyJobsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListCopyJobsResponse> {
    private static final SdkField<List<CopyJob>> COPY_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCopyJobsResponse.getter(ListCopyJobsResponse::copyJobs)).setter(ListCopyJobsResponse.setter(Builder::copyJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CopyJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCopyJobsResponse.getter(ListCopyJobsResponse::nextToken)).setter(ListCopyJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CopyJob> copyJobs;
    private final String nextToken;

    private ListCopyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.copyJobs = builder.copyJobs;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCopyJobs() {
        return this.copyJobs != null && !(this.copyJobs instanceof SdkAutoConstructList);
    }

    public List<CopyJob> copyJobs() {
        return this.copyJobs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.copyJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCopyJobsResponse)) {
            return false;
        }
        ListCopyJobsResponse other = (ListCopyJobsResponse)((Object)obj);
        return Objects.equals(this.copyJobs(), other.copyJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCopyJobsResponse").add("CopyJobs", this.copyJobs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopyJobs": {
                return Optional.ofNullable(clazz.cast(this.copyJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCopyJobsResponse, T> g) {
        return obj -> g.apply((ListCopyJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<CopyJob> copyJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCopyJobsResponse model) {
            super(model);
            this.copyJobs(model.copyJobs);
            this.nextToken(model.nextToken);
        }

        public final Collection<CopyJob.Builder> getCopyJobs() {
            return this.copyJobs != null ? (Collection)this.copyJobs.stream().map(CopyJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder copyJobs(Collection<CopyJob> copyJobs) {
            this.copyJobs = CopyJobsListCopier.copy(copyJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobs(CopyJob ... copyJobs) {
            this.copyJobs(Arrays.asList(copyJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyJobs(Consumer<CopyJob.Builder> ... copyJobs) {
            this.copyJobs(Stream.of(copyJobs).map(c -> (CopyJob)((CopyJob.Builder)CopyJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCopyJobs(Collection<CopyJob.BuilderImpl> copyJobs) {
            this.copyJobs = CopyJobsListCopier.copyFromBuilder(copyJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCopyJobsResponse build() {
            return new ListCopyJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCopyJobsResponse> {
        public Builder copyJobs(Collection<CopyJob> var1);

        public Builder copyJobs(CopyJob ... var1);

        public Builder copyJobs(Consumer<CopyJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

