/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.AlreadyExistsException;
import software.amazon.awssdk.services.backup.model.BackupException;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DependencyFailureException;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.InvalidParameterValueException;
import software.amazon.awssdk.services.backup.model.InvalidRequestException;
import software.amazon.awssdk.services.backup.model.LimitExceededException;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.MissingParameterValueException;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backup.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListTagsIterable;
import software.amazon.awssdk.services.backup.transform.CreateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeProtectedResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ExportBackupPlanTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromJsonRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRecoveryPointRestoreMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetSupportedResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanTemplatesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanVersionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupSelectionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupVaultsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListProtectedResourcesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StopBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRecoveryPointLifecycleRequestMarshaller;

@SdkInternalApi
final class DefaultBackupClient
implements BackupClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBackupClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "backup";
    }

    @Override
    public CreateBackupPlanResponse createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest) throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBackupPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackupPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupPlanRequest).withMarshaller((Marshaller)new CreateBackupPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBackupSelectionResponse createBackupSelection(CreateBackupSelectionRequest createBackupSelectionRequest) throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupSelectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBackupSelectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackupSelection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupSelectionRequest).withMarshaller((Marshaller)new CreateBackupSelectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBackupVaultResponse createBackupVault(CreateBackupVaultRequest createBackupVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBackupVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackupVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBackupVaultRequest).withMarshaller((Marshaller)new CreateBackupVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupPlanResponse deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackupPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupPlanRequest).withMarshaller((Marshaller)new DeleteBackupPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupSelectionResponse deleteBackupSelection(DeleteBackupSelectionRequest deleteBackupSelectionRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupSelectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupSelectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackupSelection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupSelectionRequest).withMarshaller((Marshaller)new DeleteBackupSelectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupVaultResponse deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackupVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupVaultRequest).withMarshaller((Marshaller)new DeleteBackupVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackupVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupVaultAccessPolicyRequest).withMarshaller((Marshaller)new DeleteBackupVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBackupVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackupVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBackupVaultNotificationsRequest).withMarshaller((Marshaller)new DeleteBackupVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRecoveryPointResponse deleteRecoveryPoint(DeleteRecoveryPointRequest deleteRecoveryPointRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecoveryPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRecoveryPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecoveryPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRecoveryPointRequest).withMarshaller((Marshaller)new DeleteRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBackupJobResponse describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeBackupJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackupJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupJobRequest).withMarshaller((Marshaller)new DescribeBackupJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeBackupVaultResponse describeBackupVault(DescribeBackupVaultRequest describeBackupVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeBackupVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackupVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupVaultRequest).withMarshaller((Marshaller)new DescribeBackupVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProtectedResourceResponse describeProtectedResource(DescribeProtectedResourceRequest describeProtectedResourceRequest) throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProtectedResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProtectedResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProtectedResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProtectedResourceRequest).withMarshaller((Marshaller)new DescribeProtectedResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRecoveryPointResponse describeRecoveryPoint(DescribeRecoveryPointRequest describeRecoveryPointRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecoveryPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRecoveryPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecoveryPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecoveryPointRequest).withMarshaller((Marshaller)new DescribeRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRestoreJobResponse describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRestoreJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRestoreJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRestoreJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRestoreJobRequest).withMarshaller((Marshaller)new DescribeRestoreJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ExportBackupPlanTemplateResponse exportBackupPlanTemplate(ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportBackupPlanTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ExportBackupPlanTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportBackupPlanTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportBackupPlanTemplateRequest).withMarshaller((Marshaller)new ExportBackupPlanTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupPlanResponse getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupPlanRequest).withMarshaller((Marshaller)new GetBackupPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupPlanFromJsonResponse getBackupPlanFromJSON(GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest) throws LimitExceededException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupPlanFromJsonResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupPlanFromJsonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupPlanFromJSON").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupPlanFromJsonRequest).withMarshaller((Marshaller)new GetBackupPlanFromJsonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupPlanFromTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupPlanFromTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupPlanFromTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupPlanFromTemplateRequest).withMarshaller((Marshaller)new GetBackupPlanFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupSelectionResponse getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupSelectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupSelectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupSelection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupSelectionRequest).withMarshaller((Marshaller)new GetBackupSelectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupVaultAccessPolicyRequest).withMarshaller((Marshaller)new GetBackupVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBackupVaultNotificationsResponse getBackupVaultNotifications(GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackupVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBackupVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackupVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBackupVaultNotificationsRequest).withMarshaller((Marshaller)new GetBackupVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecoveryPointRestoreMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRecoveryPointRestoreMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecoveryPointRestoreMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecoveryPointRestoreMetadataRequest).withMarshaller((Marshaller)new GetRecoveryPointRestoreMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetSupportedResourceTypesResponse getSupportedResourceTypes(GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) throws ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSupportedResourceTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetSupportedResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSupportedResourceTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSupportedResourceTypesRequest).withMarshaller((Marshaller)new GetSupportedResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupJobsResponse listBackupJobs(ListBackupJobsRequest listBackupJobsRequest) throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupJobsRequest).withMarshaller((Marshaller)new ListBackupJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupJobsIterable listBackupJobsPaginator(ListBackupJobsRequest listBackupJobsRequest) throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupJobsIterable(this, this.applyPaginatorUserAgent(listBackupJobsRequest));
    }

    @Override
    public ListBackupPlanTemplatesResponse listBackupPlanTemplates(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupPlanTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupPlanTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupPlanTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupPlanTemplatesRequest).withMarshaller((Marshaller)new ListBackupPlanTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupPlanTemplatesIterable(this, this.applyPaginatorUserAgent(listBackupPlanTemplatesRequest));
    }

    @Override
    public ListBackupPlanVersionsResponse listBackupPlanVersions(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupPlanVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupPlanVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupPlanVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupPlanVersionsRequest).withMarshaller((Marshaller)new ListBackupPlanVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupPlanVersionsIterable listBackupPlanVersionsPaginator(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupPlanVersionsIterable(this, this.applyPaginatorUserAgent(listBackupPlanVersionsRequest));
    }

    @Override
    public ListBackupPlansResponse listBackupPlans(ListBackupPlansRequest listBackupPlansRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupPlansResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupPlansResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupPlans").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupPlansRequest).withMarshaller((Marshaller)new ListBackupPlansRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupPlansIterable listBackupPlansPaginator(ListBackupPlansRequest listBackupPlansRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupPlansIterable(this, this.applyPaginatorUserAgent(listBackupPlansRequest));
    }

    @Override
    public ListBackupSelectionsResponse listBackupSelections(ListBackupSelectionsRequest listBackupSelectionsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupSelectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupSelectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupSelections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupSelectionsRequest).withMarshaller((Marshaller)new ListBackupSelectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupSelectionsIterable listBackupSelectionsPaginator(ListBackupSelectionsRequest listBackupSelectionsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupSelectionsIterable(this, this.applyPaginatorUserAgent(listBackupSelectionsRequest));
    }

    @Override
    public ListBackupVaultsResponse listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupVaultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBackupVaultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackupVaults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBackupVaultsRequest).withMarshaller((Marshaller)new ListBackupVaultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBackupVaultsIterable listBackupVaultsPaginator(ListBackupVaultsRequest listBackupVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupVaultsIterable(this, this.applyPaginatorUserAgent(listBackupVaultsRequest));
    }

    @Override
    public ListProtectedResourcesResponse listProtectedResources(ListProtectedResourcesRequest listProtectedResourcesRequest) throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProtectedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProtectedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProtectedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProtectedResourcesRequest).withMarshaller((Marshaller)new ListProtectedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProtectedResourcesIterable listProtectedResourcesPaginator(ListProtectedResourcesRequest listProtectedResourcesRequest) throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListProtectedResourcesIterable(this, this.applyPaginatorUserAgent(listProtectedResourcesRequest));
    }

    @Override
    public ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecoveryPointsByBackupVaultResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRecoveryPointsByBackupVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecoveryPointsByBackupVault").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecoveryPointsByBackupVaultRequest).withMarshaller((Marshaller)new ListRecoveryPointsByBackupVaultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRecoveryPointsByBackupVaultIterable listRecoveryPointsByBackupVaultPaginator(ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRecoveryPointsByBackupVaultIterable(this, this.applyPaginatorUserAgent(listRecoveryPointsByBackupVaultRequest));
    }

    @Override
    public ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecoveryPointsByResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRecoveryPointsByResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecoveryPointsByResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecoveryPointsByResourceRequest).withMarshaller((Marshaller)new ListRecoveryPointsByResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRecoveryPointsByResourceIterable listRecoveryPointsByResourcePaginator(ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRecoveryPointsByResourceIterable(this, this.applyPaginatorUserAgent(listRecoveryPointsByResourceRequest));
    }

    @Override
    public ListRestoreJobsResponse listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRestoreJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRestoreJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRestoreJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRestoreJobsRequest).withMarshaller((Marshaller)new ListRestoreJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRestoreJobsIterable listRestoreJobsPaginator(ListRestoreJobsRequest listRestoreJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRestoreJobsIterable(this, this.applyPaginatorUserAgent(listRestoreJobsRequest));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListTagsIterable(this, this.applyPaginatorUserAgent(listTagsRequest));
    }

    @Override
    public PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutBackupVaultAccessPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutBackupVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBackupVaultAccessPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putBackupVaultAccessPolicyRequest).withMarshaller((Marshaller)new PutBackupVaultAccessPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBackupVaultNotificationsResponse putBackupVaultNotifications(PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutBackupVaultNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutBackupVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBackupVaultNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putBackupVaultNotificationsRequest).withMarshaller((Marshaller)new PutBackupVaultNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartBackupJobResponse startBackupJob(StartBackupJobRequest startBackupJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBackupJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartBackupJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBackupJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startBackupJobRequest).withMarshaller((Marshaller)new StartBackupJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartRestoreJobResponse startRestoreJob(StartRestoreJobRequest startRestoreJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRestoreJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartRestoreJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRestoreJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startRestoreJobRequest).withMarshaller((Marshaller)new StartRestoreJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopBackupJobResponse stopBackupJob(StopBackupJobRequest stopBackupJobRequest) throws MissingParameterValueException, ResourceNotFoundException, InvalidParameterValueException, InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopBackupJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopBackupJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopBackupJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopBackupJobRequest).withMarshaller((Marshaller)new StopBackupJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateBackupPlanResponse updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackupPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateBackupPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackupPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBackupPlanRequest).withMarshaller((Marshaller)new UpdateBackupPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecoveryPointLifecycleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRecoveryPointLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecoveryPointLifecycle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRecoveryPointLifecycleRequest).withMarshaller((Marshaller)new UpdateRecoveryPointLifecycleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BackupException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("MissingParameterValueException").exceptionBuilderSupplier(MissingParameterValueException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyFailureException").exceptionBuilderSupplier(DependencyFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BackupRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.3").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((BackupRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

