/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single validation rule that can be applied during X12 EDI processing. This is a union type that can
 * contain one of several specific validation rule types: code list validation rules for modifying allowed element
 * codes, element length validation rules for enforcing custom length constraints, or element requirement validation
 * rules for changing mandatory/optional status. Each validation rule targets specific aspects of EDI document
 * validation to ensure compliance with trading partner requirements and business rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12ValidationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<X12ValidationRule.Builder, X12ValidationRule> {
    private static final SdkField<X12CodeListValidationRule> CODE_LIST_VALIDATION_RULE_FIELD = SdkField
            .<X12CodeListValidationRule> builder(MarshallingType.SDK_POJO).memberName("codeListValidationRule")
            .getter(getter(X12ValidationRule::codeListValidationRule)).setter(setter(Builder::codeListValidationRule))
            .constructor(X12CodeListValidationRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeListValidationRule").build())
            .build();

    private static final SdkField<X12ElementLengthValidationRule> ELEMENT_LENGTH_VALIDATION_RULE_FIELD = SdkField
            .<X12ElementLengthValidationRule> builder(MarshallingType.SDK_POJO)
            .memberName("elementLengthValidationRule")
            .getter(getter(X12ValidationRule::elementLengthValidationRule))
            .setter(setter(Builder::elementLengthValidationRule))
            .constructor(X12ElementLengthValidationRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementLengthValidationRule")
                    .build()).build();

    private static final SdkField<X12ElementRequirementValidationRule> ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD = SdkField
            .<X12ElementRequirementValidationRule> builder(MarshallingType.SDK_POJO)
            .memberName("elementRequirementValidationRule")
            .getter(getter(X12ValidationRule::elementRequirementValidationRule))
            .setter(setter(Builder::elementRequirementValidationRule))
            .constructor(X12ElementRequirementValidationRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementRequirementValidationRule")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_LIST_VALIDATION_RULE_FIELD, ELEMENT_LENGTH_VALIDATION_RULE_FIELD, ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12CodeListValidationRule codeListValidationRule;

    private final X12ElementLengthValidationRule elementLengthValidationRule;

    private final X12ElementRequirementValidationRule elementRequirementValidationRule;

    private final Type type;

    private X12ValidationRule(BuilderImpl builder) {
        this.codeListValidationRule = builder.codeListValidationRule;
        this.elementLengthValidationRule = builder.elementLengthValidationRule;
        this.elementRequirementValidationRule = builder.elementRequirementValidationRule;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This rule
     * enables you to customize which codes are considered valid for an element, allowing for trading partner-specific
     * code requirements.
     * </p>
     * 
     * @return Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
     *         This rule enables you to customize which codes are considered valid for an element, allowing for trading
     *         partner-specific code requirements.
     */
    public final X12CodeListValidationRule codeListValidationRule() {
        return codeListValidationRule;
    }

    /**
     * <p>
     * Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
     * This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12
     * specification.
     * </p>
     * 
     * @return Specifies an element length validation rule that defines custom length constraints for a specific X12
     *         element. This rule allows you to enforce minimum and maximum length requirements that may differ from the
     *         standard X12 specification.
     */
    public final X12ElementLengthValidationRule elementLengthValidationRule() {
        return elementLengthValidationRule;
    }

    /**
     * <p>
     * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or
     * optional within a segment. This rule provides flexibility to accommodate different trading partner requirements
     * for element presence.
     * </p>
     * 
     * @return Specifies an element requirement validation rule that modifies whether a specific X12 element is required
     *         or optional within a segment. This rule provides flexibility to accommodate different trading partner
     *         requirements for element presence.
     */
    public final X12ElementRequirementValidationRule elementRequirementValidationRule() {
        return elementRequirementValidationRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeListValidationRule());
        hashCode = 31 * hashCode + Objects.hashCode(elementLengthValidationRule());
        hashCode = 31 * hashCode + Objects.hashCode(elementRequirementValidationRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ValidationRule)) {
            return false;
        }
        X12ValidationRule other = (X12ValidationRule) obj;
        return Objects.equals(codeListValidationRule(), other.codeListValidationRule())
                && Objects.equals(elementLengthValidationRule(), other.elementLengthValidationRule())
                && Objects.equals(elementRequirementValidationRule(), other.elementRequirementValidationRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12ValidationRule").add("CodeListValidationRule", codeListValidationRule())
                .add("ElementLengthValidationRule", elementLengthValidationRule())
                .add("ElementRequirementValidationRule", elementRequirementValidationRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeListValidationRule":
            return Optional.ofNullable(clazz.cast(codeListValidationRule()));
        case "elementLengthValidationRule":
            return Optional.ofNullable(clazz.cast(elementLengthValidationRule()));
        case "elementRequirementValidationRule":
            return Optional.ofNullable(clazz.cast(elementRequirementValidationRule()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #codeListValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This rule
     * enables you to customize which codes are considered valid for an element, allowing for trading partner-specific
     * code requirements.
     * </p>
     * 
     * @param codeListValidationRule
     *        Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
     *        This rule enables you to customize which codes are considered valid for an element, allowing for trading
     *        partner-specific code requirements.
     */
    public static X12ValidationRule fromCodeListValidationRule(X12CodeListValidationRule codeListValidationRule) {
        return builder().codeListValidationRule(codeListValidationRule).build();
    }

    /**
     * Create an instance of this class with {@link #codeListValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This rule
     * enables you to customize which codes are considered valid for an element, allowing for trading partner-specific
     * code requirements.
     * </p>
     * 
     * @param codeListValidationRule
     *        Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
     *        This rule enables you to customize which codes are considered valid for an element, allowing for trading
     *        partner-specific code requirements.
     */
    public static X12ValidationRule fromCodeListValidationRule(Consumer<X12CodeListValidationRule.Builder> codeListValidationRule) {
        X12CodeListValidationRule.Builder builder = X12CodeListValidationRule.builder();
        codeListValidationRule.accept(builder);
        return fromCodeListValidationRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #elementLengthValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
     * This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12
     * specification.
     * </p>
     * 
     * @param elementLengthValidationRule
     *        Specifies an element length validation rule that defines custom length constraints for a specific X12
     *        element. This rule allows you to enforce minimum and maximum length requirements that may differ from the
     *        standard X12 specification.
     */
    public static X12ValidationRule fromElementLengthValidationRule(X12ElementLengthValidationRule elementLengthValidationRule) {
        return builder().elementLengthValidationRule(elementLengthValidationRule).build();
    }

    /**
     * Create an instance of this class with {@link #elementLengthValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
     * This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12
     * specification.
     * </p>
     * 
     * @param elementLengthValidationRule
     *        Specifies an element length validation rule that defines custom length constraints for a specific X12
     *        element. This rule allows you to enforce minimum and maximum length requirements that may differ from the
     *        standard X12 specification.
     */
    public static X12ValidationRule fromElementLengthValidationRule(
            Consumer<X12ElementLengthValidationRule.Builder> elementLengthValidationRule) {
        X12ElementLengthValidationRule.Builder builder = X12ElementLengthValidationRule.builder();
        elementLengthValidationRule.accept(builder);
        return fromElementLengthValidationRule(builder.build());
    }

    /**
     * Create an instance of this class with {@link #elementRequirementValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or
     * optional within a segment. This rule provides flexibility to accommodate different trading partner requirements
     * for element presence.
     * </p>
     * 
     * @param elementRequirementValidationRule
     *        Specifies an element requirement validation rule that modifies whether a specific X12 element is required
     *        or optional within a segment. This rule provides flexibility to accommodate different trading partner
     *        requirements for element presence.
     */
    public static X12ValidationRule fromElementRequirementValidationRule(
            X12ElementRequirementValidationRule elementRequirementValidationRule) {
        return builder().elementRequirementValidationRule(elementRequirementValidationRule).build();
    }

    /**
     * Create an instance of this class with {@link #elementRequirementValidationRule()} initialized to the given value.
     *
     * <p>
     * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or
     * optional within a segment. This rule provides flexibility to accommodate different trading partner requirements
     * for element presence.
     * </p>
     * 
     * @param elementRequirementValidationRule
     *        Specifies an element requirement validation rule that modifies whether a specific X12 element is required
     *        or optional within a segment. This rule provides flexibility to accommodate different trading partner
     *        requirements for element presence.
     */
    public static X12ValidationRule fromElementRequirementValidationRule(
            Consumer<X12ElementRequirementValidationRule.Builder> elementRequirementValidationRule) {
        X12ElementRequirementValidationRule.Builder builder = X12ElementRequirementValidationRule.builder();
        elementRequirementValidationRule.accept(builder);
        return fromElementRequirementValidationRule(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeListValidationRule", CODE_LIST_VALIDATION_RULE_FIELD);
        map.put("elementLengthValidationRule", ELEMENT_LENGTH_VALIDATION_RULE_FIELD);
        map.put("elementRequirementValidationRule", ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ValidationRule, T> g) {
        return obj -> g.apply((X12ValidationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12ValidationRule> {
        /**
         * <p>
         * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This
         * rule enables you to customize which codes are considered valid for an element, allowing for trading
         * partner-specific code requirements.
         * </p>
         * 
         * @param codeListValidationRule
         *        Specifies a code list validation rule that modifies the allowed code values for a specific X12
         *        element. This rule enables you to customize which codes are considered valid for an element, allowing
         *        for trading partner-specific code requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeListValidationRule(X12CodeListValidationRule codeListValidationRule);

        /**
         * <p>
         * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This
         * rule enables you to customize which codes are considered valid for an element, allowing for trading
         * partner-specific code requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12CodeListValidationRule.Builder}
         * avoiding the need to create one manually via {@link X12CodeListValidationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12CodeListValidationRule.Builder#build()} is called immediately
         * and its result is passed to {@link #codeListValidationRule(X12CodeListValidationRule)}.
         * 
         * @param codeListValidationRule
         *        a consumer that will call methods on {@link X12CodeListValidationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeListValidationRule(X12CodeListValidationRule)
         */
        default Builder codeListValidationRule(Consumer<X12CodeListValidationRule.Builder> codeListValidationRule) {
            return codeListValidationRule(X12CodeListValidationRule.builder().applyMutation(codeListValidationRule).build());
        }

        /**
         * <p>
         * Specifies an element length validation rule that defines custom length constraints for a specific X12
         * element. This rule allows you to enforce minimum and maximum length requirements that may differ from the
         * standard X12 specification.
         * </p>
         * 
         * @param elementLengthValidationRule
         *        Specifies an element length validation rule that defines custom length constraints for a specific X12
         *        element. This rule allows you to enforce minimum and maximum length requirements that may differ from
         *        the standard X12 specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementLengthValidationRule(X12ElementLengthValidationRule elementLengthValidationRule);

        /**
         * <p>
         * Specifies an element length validation rule that defines custom length constraints for a specific X12
         * element. This rule allows you to enforce minimum and maximum length requirements that may differ from the
         * standard X12 specification.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12ElementLengthValidationRule.Builder}
         * avoiding the need to create one manually via {@link X12ElementLengthValidationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12ElementLengthValidationRule.Builder#build()} is called
         * immediately and its result is passed to {@link #elementLengthValidationRule(X12ElementLengthValidationRule)}.
         * 
         * @param elementLengthValidationRule
         *        a consumer that will call methods on {@link X12ElementLengthValidationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elementLengthValidationRule(X12ElementLengthValidationRule)
         */
        default Builder elementLengthValidationRule(Consumer<X12ElementLengthValidationRule.Builder> elementLengthValidationRule) {
            return elementLengthValidationRule(X12ElementLengthValidationRule.builder()
                    .applyMutation(elementLengthValidationRule).build());
        }

        /**
         * <p>
         * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or
         * optional within a segment. This rule provides flexibility to accommodate different trading partner
         * requirements for element presence.
         * </p>
         * 
         * @param elementRequirementValidationRule
         *        Specifies an element requirement validation rule that modifies whether a specific X12 element is
         *        required or optional within a segment. This rule provides flexibility to accommodate different trading
         *        partner requirements for element presence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementRequirementValidationRule(X12ElementRequirementValidationRule elementRequirementValidationRule);

        /**
         * <p>
         * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or
         * optional within a segment. This rule provides flexibility to accommodate different trading partner
         * requirements for element presence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link X12ElementRequirementValidationRule.Builder} avoiding the need to create one manually via
         * {@link X12ElementRequirementValidationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12ElementRequirementValidationRule.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #elementRequirementValidationRule(X12ElementRequirementValidationRule)}.
         * 
         * @param elementRequirementValidationRule
         *        a consumer that will call methods on {@link X12ElementRequirementValidationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elementRequirementValidationRule(X12ElementRequirementValidationRule)
         */
        default Builder elementRequirementValidationRule(
                Consumer<X12ElementRequirementValidationRule.Builder> elementRequirementValidationRule) {
            return elementRequirementValidationRule(X12ElementRequirementValidationRule.builder()
                    .applyMutation(elementRequirementValidationRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12CodeListValidationRule codeListValidationRule;

        private X12ElementLengthValidationRule elementLengthValidationRule;

        private X12ElementRequirementValidationRule elementRequirementValidationRule;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(X12ValidationRule model) {
            codeListValidationRule(model.codeListValidationRule);
            elementLengthValidationRule(model.elementLengthValidationRule);
            elementRequirementValidationRule(model.elementRequirementValidationRule);
        }

        public final X12CodeListValidationRule.Builder getCodeListValidationRule() {
            return codeListValidationRule != null ? codeListValidationRule.toBuilder() : null;
        }

        public final void setCodeListValidationRule(X12CodeListValidationRule.BuilderImpl codeListValidationRule) {
            Object oldValue = this.codeListValidationRule;
            this.codeListValidationRule = codeListValidationRule != null ? codeListValidationRule.build() : null;
            handleUnionValueChange(Type.CODE_LIST_VALIDATION_RULE, oldValue, this.codeListValidationRule);
        }

        @Override
        public final Builder codeListValidationRule(X12CodeListValidationRule codeListValidationRule) {
            Object oldValue = this.codeListValidationRule;
            this.codeListValidationRule = codeListValidationRule;
            handleUnionValueChange(Type.CODE_LIST_VALIDATION_RULE, oldValue, this.codeListValidationRule);
            return this;
        }

        public final X12ElementLengthValidationRule.Builder getElementLengthValidationRule() {
            return elementLengthValidationRule != null ? elementLengthValidationRule.toBuilder() : null;
        }

        public final void setElementLengthValidationRule(X12ElementLengthValidationRule.BuilderImpl elementLengthValidationRule) {
            Object oldValue = this.elementLengthValidationRule;
            this.elementLengthValidationRule = elementLengthValidationRule != null ? elementLengthValidationRule.build() : null;
            handleUnionValueChange(Type.ELEMENT_LENGTH_VALIDATION_RULE, oldValue, this.elementLengthValidationRule);
        }

        @Override
        public final Builder elementLengthValidationRule(X12ElementLengthValidationRule elementLengthValidationRule) {
            Object oldValue = this.elementLengthValidationRule;
            this.elementLengthValidationRule = elementLengthValidationRule;
            handleUnionValueChange(Type.ELEMENT_LENGTH_VALIDATION_RULE, oldValue, this.elementLengthValidationRule);
            return this;
        }

        public final X12ElementRequirementValidationRule.Builder getElementRequirementValidationRule() {
            return elementRequirementValidationRule != null ? elementRequirementValidationRule.toBuilder() : null;
        }

        public final void setElementRequirementValidationRule(
                X12ElementRequirementValidationRule.BuilderImpl elementRequirementValidationRule) {
            Object oldValue = this.elementRequirementValidationRule;
            this.elementRequirementValidationRule = elementRequirementValidationRule != null ? elementRequirementValidationRule
                    .build() : null;
            handleUnionValueChange(Type.ELEMENT_REQUIREMENT_VALIDATION_RULE, oldValue, this.elementRequirementValidationRule);
        }

        @Override
        public final Builder elementRequirementValidationRule(X12ElementRequirementValidationRule elementRequirementValidationRule) {
            Object oldValue = this.elementRequirementValidationRule;
            this.elementRequirementValidationRule = elementRequirementValidationRule;
            handleUnionValueChange(Type.ELEMENT_REQUIREMENT_VALIDATION_RULE, oldValue, this.elementRequirementValidationRule);
            return this;
        }

        @Override
        public X12ValidationRule build() {
            return new X12ValidationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see X12ValidationRule#type()
     */
    public enum Type {
        CODE_LIST_VALIDATION_RULE,

        ELEMENT_LENGTH_VALIDATION_RULE,

        ELEMENT_REQUIREMENT_VALIDATION_RULE,

        UNKNOWN_TO_SDK_VERSION
    }
}
