/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration for X12 control numbers used in X12 EDI generation. Control numbers are used to uniquely
 * identify interchanges, functional groups, and transaction sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12ControlNumbers implements SdkPojo, Serializable,
        ToCopyableBuilder<X12ControlNumbers.Builder, X12ControlNumbers> {
    private static final SdkField<Integer> STARTING_INTERCHANGE_CONTROL_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("startingInterchangeControlNumber")
            .getter(getter(X12ControlNumbers::startingInterchangeControlNumber))
            .setter(setter(Builder::startingInterchangeControlNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startingInterchangeControlNumber")
                    .build()).build();

    private static final SdkField<Integer> STARTING_FUNCTIONAL_GROUP_CONTROL_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("startingFunctionalGroupControlNumber")
            .getter(getter(X12ControlNumbers::startingFunctionalGroupControlNumber))
            .setter(setter(Builder::startingFunctionalGroupControlNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("startingFunctionalGroupControlNumber").build()).build();

    private static final SdkField<Integer> STARTING_TRANSACTION_SET_CONTROL_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("startingTransactionSetControlNumber")
            .getter(getter(X12ControlNumbers::startingTransactionSetControlNumber))
            .setter(setter(Builder::startingTransactionSetControlNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("startingTransactionSetControlNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STARTING_INTERCHANGE_CONTROL_NUMBER_FIELD, STARTING_FUNCTIONAL_GROUP_CONTROL_NUMBER_FIELD,
            STARTING_TRANSACTION_SET_CONTROL_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer startingInterchangeControlNumber;

    private final Integer startingFunctionalGroupControlNumber;

    private final Integer startingTransactionSetControlNumber;

    private X12ControlNumbers(BuilderImpl builder) {
        this.startingInterchangeControlNumber = builder.startingInterchangeControlNumber;
        this.startingFunctionalGroupControlNumber = builder.startingFunctionalGroupControlNumber;
        this.startingTransactionSetControlNumber = builder.startingTransactionSetControlNumber;
    }

    /**
     * <p>
     * Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number is
     * incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B Data
     * Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) &amp; ISA07
     * and ISA08 (receiver) combination.
     * </p>
     * 
     * @return Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number is
     *         incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B Data
     *         Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) &amp;
     *         ISA07 and ISA08 (receiver) combination.
     */
    public final Integer startingInterchangeControlNumber() {
        return startingInterchangeControlNumber;
    }

    /**
     * <p>
     * Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This number is
     * incremented for each new functional group. For the GS (functional group) envelope, Amazon Web Services B2B Data
     * Interchange generates a functional group control number that is unique to the sender ID, receiver ID, and
     * functional identifier code combination.
     * </p>
     * 
     * @return Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This number
     *         is incremented for each new functional group. For the GS (functional group) envelope, Amazon Web Services
     *         B2B Data Interchange generates a functional group control number that is unique to the sender ID,
     *         receiver ID, and functional identifier code combination.
     */
    public final Integer startingFunctionalGroupControlNumber() {
        return startingFunctionalGroupControlNumber;
    }

    /**
     * <p>
     * Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This number is
     * incremented for each new transaction set.
     * </p>
     * 
     * @return Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This number
     *         is incremented for each new transaction set.
     */
    public final Integer startingTransactionSetControlNumber() {
        return startingTransactionSetControlNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startingInterchangeControlNumber());
        hashCode = 31 * hashCode + Objects.hashCode(startingFunctionalGroupControlNumber());
        hashCode = 31 * hashCode + Objects.hashCode(startingTransactionSetControlNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ControlNumbers)) {
            return false;
        }
        X12ControlNumbers other = (X12ControlNumbers) obj;
        return Objects.equals(startingInterchangeControlNumber(), other.startingInterchangeControlNumber())
                && Objects.equals(startingFunctionalGroupControlNumber(), other.startingFunctionalGroupControlNumber())
                && Objects.equals(startingTransactionSetControlNumber(), other.startingTransactionSetControlNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12ControlNumbers").add("StartingInterchangeControlNumber", startingInterchangeControlNumber())
                .add("StartingFunctionalGroupControlNumber", startingFunctionalGroupControlNumber())
                .add("StartingTransactionSetControlNumber", startingTransactionSetControlNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startingInterchangeControlNumber":
            return Optional.ofNullable(clazz.cast(startingInterchangeControlNumber()));
        case "startingFunctionalGroupControlNumber":
            return Optional.ofNullable(clazz.cast(startingFunctionalGroupControlNumber()));
        case "startingTransactionSetControlNumber":
            return Optional.ofNullable(clazz.cast(startingTransactionSetControlNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startingInterchangeControlNumber", STARTING_INTERCHANGE_CONTROL_NUMBER_FIELD);
        map.put("startingFunctionalGroupControlNumber", STARTING_FUNCTIONAL_GROUP_CONTROL_NUMBER_FIELD);
        map.put("startingTransactionSetControlNumber", STARTING_TRANSACTION_SET_CONTROL_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ControlNumbers, T> g) {
        return obj -> g.apply((X12ControlNumbers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12ControlNumbers> {
        /**
         * <p>
         * Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number is
         * incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B Data
         * Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) &amp;
         * ISA07 and ISA08 (receiver) combination.
         * </p>
         * 
         * @param startingInterchangeControlNumber
         *        Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number
         *        is incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B
         *        Data Interchange generates an interchange control number that is unique for the ISA05 and ISA06
         *        (sender) &amp; ISA07 and ISA08 (receiver) combination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInterchangeControlNumber(Integer startingInterchangeControlNumber);

        /**
         * <p>
         * Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This number is
         * incremented for each new functional group. For the GS (functional group) envelope, Amazon Web Services B2B
         * Data Interchange generates a functional group control number that is unique to the sender ID, receiver ID,
         * and functional identifier code combination.
         * </p>
         * 
         * @param startingFunctionalGroupControlNumber
         *        Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This
         *        number is incremented for each new functional group. For the GS (functional group) envelope, Amazon
         *        Web Services B2B Data Interchange generates a functional group control number that is unique to the
         *        sender ID, receiver ID, and functional identifier code combination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingFunctionalGroupControlNumber(Integer startingFunctionalGroupControlNumber);

        /**
         * <p>
         * Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This number is
         * incremented for each new transaction set.
         * </p>
         * 
         * @param startingTransactionSetControlNumber
         *        Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This
         *        number is incremented for each new transaction set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingTransactionSetControlNumber(Integer startingTransactionSetControlNumber);
    }

    static final class BuilderImpl implements Builder {
        private Integer startingInterchangeControlNumber;

        private Integer startingFunctionalGroupControlNumber;

        private Integer startingTransactionSetControlNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(X12ControlNumbers model) {
            startingInterchangeControlNumber(model.startingInterchangeControlNumber);
            startingFunctionalGroupControlNumber(model.startingFunctionalGroupControlNumber);
            startingTransactionSetControlNumber(model.startingTransactionSetControlNumber);
        }

        public final Integer getStartingInterchangeControlNumber() {
            return startingInterchangeControlNumber;
        }

        public final void setStartingInterchangeControlNumber(Integer startingInterchangeControlNumber) {
            this.startingInterchangeControlNumber = startingInterchangeControlNumber;
        }

        @Override
        public final Builder startingInterchangeControlNumber(Integer startingInterchangeControlNumber) {
            this.startingInterchangeControlNumber = startingInterchangeControlNumber;
            return this;
        }

        public final Integer getStartingFunctionalGroupControlNumber() {
            return startingFunctionalGroupControlNumber;
        }

        public final void setStartingFunctionalGroupControlNumber(Integer startingFunctionalGroupControlNumber) {
            this.startingFunctionalGroupControlNumber = startingFunctionalGroupControlNumber;
        }

        @Override
        public final Builder startingFunctionalGroupControlNumber(Integer startingFunctionalGroupControlNumber) {
            this.startingFunctionalGroupControlNumber = startingFunctionalGroupControlNumber;
            return this;
        }

        public final Integer getStartingTransactionSetControlNumber() {
            return startingTransactionSetControlNumber;
        }

        public final void setStartingTransactionSetControlNumber(Integer startingTransactionSetControlNumber) {
            this.startingTransactionSetControlNumber = startingTransactionSetControlNumber;
        }

        @Override
        public final Builder startingTransactionSetControlNumber(Integer startingTransactionSetControlNumber) {
            this.startingTransactionSetControlNumber = startingTransactionSetControlNumber;
            return this;
        }

        @Override
        public X12ControlNumbers build() {
            return new X12ControlNumbers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
