/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains advanced options specific to X12 EDI processing, such as splitting large X12 files into smaller units.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12AdvancedOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<X12AdvancedOptions.Builder, X12AdvancedOptions> {
    private static final SdkField<X12SplitOptions> SPLIT_OPTIONS_FIELD = SdkField
            .<X12SplitOptions> builder(MarshallingType.SDK_POJO).memberName("splitOptions")
            .getter(getter(X12AdvancedOptions::splitOptions)).setter(setter(Builder::splitOptions))
            .constructor(X12SplitOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("splitOptions").build()).build();

    private static final SdkField<X12ValidationOptions> VALIDATION_OPTIONS_FIELD = SdkField
            .<X12ValidationOptions> builder(MarshallingType.SDK_POJO).memberName("validationOptions")
            .getter(getter(X12AdvancedOptions::validationOptions)).setter(setter(Builder::validationOptions))
            .constructor(X12ValidationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPLIT_OPTIONS_FIELD,
            VALIDATION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12SplitOptions splitOptions;

    private final X12ValidationOptions validationOptions;

    private X12AdvancedOptions(BuilderImpl builder) {
        this.splitOptions = builder.splitOptions;
        this.validationOptions = builder.validationOptions;
    }

    /**
     * <p>
     * Specifies options for splitting X12 EDI files. These options control how large X12 files are divided into
     * smaller, more manageable units.
     * </p>
     * 
     * @return Specifies options for splitting X12 EDI files. These options control how large X12 files are divided into
     *         smaller, more manageable units.
     */
    public final X12SplitOptions splitOptions() {
        return splitOptions;
    }

    /**
     * <p>
     * Specifies validation options for X12 EDI processing. These options control how validation rules are applied
     * during EDI document processing, including custom validation rules for element length constraints, code list
     * validations, and element requirement checks.
     * </p>
     * 
     * @return Specifies validation options for X12 EDI processing. These options control how validation rules are
     *         applied during EDI document processing, including custom validation rules for element length constraints,
     *         code list validations, and element requirement checks.
     */
    public final X12ValidationOptions validationOptions() {
        return validationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(splitOptions());
        hashCode = 31 * hashCode + Objects.hashCode(validationOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12AdvancedOptions)) {
            return false;
        }
        X12AdvancedOptions other = (X12AdvancedOptions) obj;
        return Objects.equals(splitOptions(), other.splitOptions())
                && Objects.equals(validationOptions(), other.validationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12AdvancedOptions").add("SplitOptions", splitOptions())
                .add("ValidationOptions", validationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "splitOptions":
            return Optional.ofNullable(clazz.cast(splitOptions()));
        case "validationOptions":
            return Optional.ofNullable(clazz.cast(validationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("splitOptions", SPLIT_OPTIONS_FIELD);
        map.put("validationOptions", VALIDATION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12AdvancedOptions, T> g) {
        return obj -> g.apply((X12AdvancedOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12AdvancedOptions> {
        /**
         * <p>
         * Specifies options for splitting X12 EDI files. These options control how large X12 files are divided into
         * smaller, more manageable units.
         * </p>
         * 
         * @param splitOptions
         *        Specifies options for splitting X12 EDI files. These options control how large X12 files are divided
         *        into smaller, more manageable units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitOptions(X12SplitOptions splitOptions);

        /**
         * <p>
         * Specifies options for splitting X12 EDI files. These options control how large X12 files are divided into
         * smaller, more manageable units.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12SplitOptions.Builder} avoiding the
         * need to create one manually via {@link X12SplitOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12SplitOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #splitOptions(X12SplitOptions)}.
         * 
         * @param splitOptions
         *        a consumer that will call methods on {@link X12SplitOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #splitOptions(X12SplitOptions)
         */
        default Builder splitOptions(Consumer<X12SplitOptions.Builder> splitOptions) {
            return splitOptions(X12SplitOptions.builder().applyMutation(splitOptions).build());
        }

        /**
         * <p>
         * Specifies validation options for X12 EDI processing. These options control how validation rules are applied
         * during EDI document processing, including custom validation rules for element length constraints, code list
         * validations, and element requirement checks.
         * </p>
         * 
         * @param validationOptions
         *        Specifies validation options for X12 EDI processing. These options control how validation rules are
         *        applied during EDI document processing, including custom validation rules for element length
         *        constraints, code list validations, and element requirement checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationOptions(X12ValidationOptions validationOptions);

        /**
         * <p>
         * Specifies validation options for X12 EDI processing. These options control how validation rules are applied
         * during EDI document processing, including custom validation rules for element length constraints, code list
         * validations, and element requirement checks.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12ValidationOptions.Builder} avoiding
         * the need to create one manually via {@link X12ValidationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12ValidationOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #validationOptions(X12ValidationOptions)}.
         * 
         * @param validationOptions
         *        a consumer that will call methods on {@link X12ValidationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationOptions(X12ValidationOptions)
         */
        default Builder validationOptions(Consumer<X12ValidationOptions.Builder> validationOptions) {
            return validationOptions(X12ValidationOptions.builder().applyMutation(validationOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12SplitOptions splitOptions;

        private X12ValidationOptions validationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(X12AdvancedOptions model) {
            splitOptions(model.splitOptions);
            validationOptions(model.validationOptions);
        }

        public final X12SplitOptions.Builder getSplitOptions() {
            return splitOptions != null ? splitOptions.toBuilder() : null;
        }

        public final void setSplitOptions(X12SplitOptions.BuilderImpl splitOptions) {
            this.splitOptions = splitOptions != null ? splitOptions.build() : null;
        }

        @Override
        public final Builder splitOptions(X12SplitOptions splitOptions) {
            this.splitOptions = splitOptions;
            return this;
        }

        public final X12ValidationOptions.Builder getValidationOptions() {
            return validationOptions != null ? validationOptions.toBuilder() : null;
        }

        public final void setValidationOptions(X12ValidationOptions.BuilderImpl validationOptions) {
            this.validationOptions = validationOptions != null ? validationOptions.build() : null;
        }

        @Override
        public final Builder validationOptions(X12ValidationOptions validationOptions) {
            this.validationOptions = validationOptions;
            return this;
        }

        @Override
        public X12AdvancedOptions build() {
            return new X12AdvancedOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
