/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains options for configuring X12 acknowledgments. These options control how functional and technical
 * acknowledgments are handled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12AcknowledgmentOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<X12AcknowledgmentOptions.Builder, X12AcknowledgmentOptions> {
    private static final SdkField<String> FUNCTIONAL_ACKNOWLEDGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionalAcknowledgment").getter(getter(X12AcknowledgmentOptions::functionalAcknowledgmentAsString))
            .setter(setter(Builder::functionalAcknowledgment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionalAcknowledgment").build())
            .build();

    private static final SdkField<String> TECHNICAL_ACKNOWLEDGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("technicalAcknowledgment").getter(getter(X12AcknowledgmentOptions::technicalAcknowledgmentAsString))
            .setter(setter(Builder::technicalAcknowledgment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalAcknowledgment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FUNCTIONAL_ACKNOWLEDGMENT_FIELD, TECHNICAL_ACKNOWLEDGMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionalAcknowledgment;

    private final String technicalAcknowledgment;

    private X12AcknowledgmentOptions(BuilderImpl builder) {
        this.functionalAcknowledgment = builder.functionalAcknowledgment;
        this.technicalAcknowledgment = builder.technicalAcknowledgment;
    }

    /**
     * <p>
     * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions. Valid
     * values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
     * <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.
     * </p>
     * <p>
     * If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
     * Interchange skips the AK2_Loop when generating an acknowledgment document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #functionalAcknowledgment} will return {@link X12FunctionalAcknowledgment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #functionalAcknowledgmentAsString}.
     * </p>
     * 
     * @return Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions.
     *         Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
     *         <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.</p>
     *         <p>
     *         If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
     *         Interchange skips the AK2_Loop when generating an acknowledgment document.
     * @see X12FunctionalAcknowledgment
     */
    public final X12FunctionalAcknowledgment functionalAcknowledgment() {
        return X12FunctionalAcknowledgment.fromValue(functionalAcknowledgment);
    }

    /**
     * <p>
     * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions. Valid
     * values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
     * <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.
     * </p>
     * <p>
     * If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
     * Interchange skips the AK2_Loop when generating an acknowledgment document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #functionalAcknowledgment} will return {@link X12FunctionalAcknowledgment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #functionalAcknowledgmentAsString}.
     * </p>
     * 
     * @return Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions.
     *         Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
     *         <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.</p>
     *         <p>
     *         If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
     *         Interchange skips the AK2_Loop when generating an acknowledgment document.
     * @see X12FunctionalAcknowledgment
     */
    public final String functionalAcknowledgmentAsString() {
        return functionalAcknowledgment;
    }

    /**
     * <p>
     * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid values
     * are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #technicalAcknowledgment} will return {@link X12TechnicalAcknowledgment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #technicalAcknowledgmentAsString}.
     * </p>
     * 
     * @return Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges.
     *         Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
     * @see X12TechnicalAcknowledgment
     */
    public final X12TechnicalAcknowledgment technicalAcknowledgment() {
        return X12TechnicalAcknowledgment.fromValue(technicalAcknowledgment);
    }

    /**
     * <p>
     * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid values
     * are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #technicalAcknowledgment} will return {@link X12TechnicalAcknowledgment#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #technicalAcknowledgmentAsString}.
     * </p>
     * 
     * @return Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges.
     *         Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
     * @see X12TechnicalAcknowledgment
     */
    public final String technicalAcknowledgmentAsString() {
        return technicalAcknowledgment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionalAcknowledgmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(technicalAcknowledgmentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12AcknowledgmentOptions)) {
            return false;
        }
        X12AcknowledgmentOptions other = (X12AcknowledgmentOptions) obj;
        return Objects.equals(functionalAcknowledgmentAsString(), other.functionalAcknowledgmentAsString())
                && Objects.equals(technicalAcknowledgmentAsString(), other.technicalAcknowledgmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12AcknowledgmentOptions").add("FunctionalAcknowledgment", functionalAcknowledgmentAsString())
                .add("TechnicalAcknowledgment", technicalAcknowledgmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionalAcknowledgment":
            return Optional.ofNullable(clazz.cast(functionalAcknowledgmentAsString()));
        case "technicalAcknowledgment":
            return Optional.ofNullable(clazz.cast(technicalAcknowledgmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("functionalAcknowledgment", FUNCTIONAL_ACKNOWLEDGMENT_FIELD);
        map.put("technicalAcknowledgment", TECHNICAL_ACKNOWLEDGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12AcknowledgmentOptions, T> g) {
        return obj -> g.apply((X12AcknowledgmentOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12AcknowledgmentOptions> {
        /**
         * <p>
         * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions.
         * Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
         * <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.
         * </p>
         * <p>
         * If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
         * Interchange skips the AK2_Loop when generating an acknowledgment document.
         * </p>
         * 
         * @param functionalAcknowledgment
         *        Specifies whether functional acknowledgments (997/999) should be generated for incoming X12
         *        transactions. Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
         *        <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.</p>
         *        <p>
         *        If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B
         *        Data Interchange skips the AK2_Loop when generating an acknowledgment document.
         * @see X12FunctionalAcknowledgment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12FunctionalAcknowledgment
         */
        Builder functionalAcknowledgment(String functionalAcknowledgment);

        /**
         * <p>
         * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions.
         * Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
         * <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.
         * </p>
         * <p>
         * If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B Data
         * Interchange skips the AK2_Loop when generating an acknowledgment document.
         * </p>
         * 
         * @param functionalAcknowledgment
         *        Specifies whether functional acknowledgments (997/999) should be generated for incoming X12
         *        transactions. Valid values are <code>DO_NOT_GENERATE</code>, <code>GENERATE_ALL_SEGMENTS</code> and
         *        <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>.</p>
         *        <p>
         *        If you choose <code>GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP</code>, Amazon Web Services B2B
         *        Data Interchange skips the AK2_Loop when generating an acknowledgment document.
         * @see X12FunctionalAcknowledgment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12FunctionalAcknowledgment
         */
        Builder functionalAcknowledgment(X12FunctionalAcknowledgment functionalAcknowledgment);

        /**
         * <p>
         * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid
         * values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
         * </p>
         * 
         * @param technicalAcknowledgment
         *        Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges.
         *        Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
         * @see X12TechnicalAcknowledgment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12TechnicalAcknowledgment
         */
        Builder technicalAcknowledgment(String technicalAcknowledgment);

        /**
         * <p>
         * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid
         * values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
         * </p>
         * 
         * @param technicalAcknowledgment
         *        Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges.
         *        Valid values are <code>DO_NOT_GENERATE</code> and <code>GENERATE_ALL_SEGMENTS</code> and.
         * @see X12TechnicalAcknowledgment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see X12TechnicalAcknowledgment
         */
        Builder technicalAcknowledgment(X12TechnicalAcknowledgment technicalAcknowledgment);
    }

    static final class BuilderImpl implements Builder {
        private String functionalAcknowledgment;

        private String technicalAcknowledgment;

        private BuilderImpl() {
        }

        private BuilderImpl(X12AcknowledgmentOptions model) {
            functionalAcknowledgment(model.functionalAcknowledgment);
            technicalAcknowledgment(model.technicalAcknowledgment);
        }

        public final String getFunctionalAcknowledgment() {
            return functionalAcknowledgment;
        }

        public final void setFunctionalAcknowledgment(String functionalAcknowledgment) {
            this.functionalAcknowledgment = functionalAcknowledgment;
        }

        @Override
        public final Builder functionalAcknowledgment(String functionalAcknowledgment) {
            this.functionalAcknowledgment = functionalAcknowledgment;
            return this;
        }

        @Override
        public final Builder functionalAcknowledgment(X12FunctionalAcknowledgment functionalAcknowledgment) {
            this.functionalAcknowledgment(functionalAcknowledgment == null ? null : functionalAcknowledgment.toString());
            return this;
        }

        public final String getTechnicalAcknowledgment() {
            return technicalAcknowledgment;
        }

        public final void setTechnicalAcknowledgment(String technicalAcknowledgment) {
            this.technicalAcknowledgment = technicalAcknowledgment;
        }

        @Override
        public final Builder technicalAcknowledgment(String technicalAcknowledgment) {
            this.technicalAcknowledgment = technicalAcknowledgment;
            return this;
        }

        @Override
        public final Builder technicalAcknowledgment(X12TechnicalAcknowledgment technicalAcknowledgment) {
            this.technicalAcknowledgment(technicalAcknowledgment == null ? null : technicalAcknowledgment.toString());
            return this;
        }

        @Override
        public X12AcknowledgmentOptions build() {
            return new X12AcknowledgmentOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
