/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestParsingResponse extends B2BiResponse implements
        ToCopyableBuilder<TestParsingResponse.Builder, TestParsingResponse> {
    private static final SdkField<String> PARSED_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parsedFileContent").getter(getter(TestParsingResponse::parsedFileContent))
            .setter(setter(Builder::parsedFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedFileContent").build()).build();

    private static final SdkField<List<String>> PARSED_SPLIT_FILE_CONTENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("parsedSplitFileContents")
            .getter(getter(TestParsingResponse::parsedSplitFileContents))
            .setter(setter(Builder::parsedSplitFileContents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedSplitFileContents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VALIDATION_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("validationMessages")
            .getter(getter(TestParsingResponse::validationMessages))
            .setter(setter(Builder::validationMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARSED_FILE_CONTENT_FIELD,
            PARSED_SPLIT_FILE_CONTENTS_FIELD, VALIDATION_MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String parsedFileContent;

    private final List<String> parsedSplitFileContents;

    private final List<String> validationMessages;

    private TestParsingResponse(BuilderImpl builder) {
        super(builder);
        this.parsedFileContent = builder.parsedFileContent;
        this.parsedSplitFileContents = builder.parsedSplitFileContents;
        this.validationMessages = builder.validationMessages;
    }

    /**
     * <p>
     * Returns the contents of the input file being tested, parsed according to the specified EDI (electronic data
     * interchange) type.
     * </p>
     * 
     * @return Returns the contents of the input file being tested, parsed according to the specified EDI (electronic
     *         data interchange) type.
     */
    public final String parsedFileContent() {
        return parsedFileContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParsedSplitFileContents property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParsedSplitFileContents() {
        return parsedSplitFileContents != null && !(parsedSplitFileContents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of parsed file contents when the input file is split according to the specified split options.
     * Each element in the array represents a separate split file's parsed content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParsedSplitFileContents} method.
     * </p>
     * 
     * @return Returns an array of parsed file contents when the input file is split according to the specified split
     *         options. Each element in the array represents a separate split file's parsed content.
     */
    public final List<String> parsedSplitFileContents() {
        return parsedSplitFileContents;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationMessages() {
        return validationMessages != null && !(validationMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of validation messages generated during EDI validation. These messages provide detailed
     * information about validation errors, warnings, or confirmations based on the configured X12 validation rules such
     * as element length constraints, code list validations, and element requirement checks. This field is populated
     * when the <code>TestParsing</code> API validates EDI documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationMessages} method.
     * </p>
     * 
     * @return Returns an array of validation messages generated during EDI validation. These messages provide detailed
     *         information about validation errors, warnings, or confirmations based on the configured X12 validation
     *         rules such as element length constraints, code list validations, and element requirement checks. This
     *         field is populated when the <code>TestParsing</code> API validates EDI documents.
     */
    public final List<String> validationMessages() {
        return validationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parsedFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasParsedSplitFileContents() ? parsedSplitFileContents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationMessages() ? validationMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestParsingResponse)) {
            return false;
        }
        TestParsingResponse other = (TestParsingResponse) obj;
        return Objects.equals(parsedFileContent(), other.parsedFileContent())
                && hasParsedSplitFileContents() == other.hasParsedSplitFileContents()
                && Objects.equals(parsedSplitFileContents(), other.parsedSplitFileContents())
                && hasValidationMessages() == other.hasValidationMessages()
                && Objects.equals(validationMessages(), other.validationMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestParsingResponse").add("ParsedFileContent", parsedFileContent())
                .add("ParsedSplitFileContents", hasParsedSplitFileContents() ? parsedSplitFileContents() : null)
                .add("ValidationMessages", hasValidationMessages() ? validationMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parsedFileContent":
            return Optional.ofNullable(clazz.cast(parsedFileContent()));
        case "parsedSplitFileContents":
            return Optional.ofNullable(clazz.cast(parsedSplitFileContents()));
        case "validationMessages":
            return Optional.ofNullable(clazz.cast(validationMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parsedFileContent", PARSED_FILE_CONTENT_FIELD);
        map.put("parsedSplitFileContents", PARSED_SPLIT_FILE_CONTENTS_FIELD);
        map.put("validationMessages", VALIDATION_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestParsingResponse, T> g) {
        return obj -> g.apply((TestParsingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestParsingResponse> {
        /**
         * <p>
         * Returns the contents of the input file being tested, parsed according to the specified EDI (electronic data
         * interchange) type.
         * </p>
         * 
         * @param parsedFileContent
         *        Returns the contents of the input file being tested, parsed according to the specified EDI (electronic
         *        data interchange) type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedFileContent(String parsedFileContent);

        /**
         * <p>
         * Returns an array of parsed file contents when the input file is split according to the specified split
         * options. Each element in the array represents a separate split file's parsed content.
         * </p>
         * 
         * @param parsedSplitFileContents
         *        Returns an array of parsed file contents when the input file is split according to the specified split
         *        options. Each element in the array represents a separate split file's parsed content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedSplitFileContents(Collection<String> parsedSplitFileContents);

        /**
         * <p>
         * Returns an array of parsed file contents when the input file is split according to the specified split
         * options. Each element in the array represents a separate split file's parsed content.
         * </p>
         * 
         * @param parsedSplitFileContents
         *        Returns an array of parsed file contents when the input file is split according to the specified split
         *        options. Each element in the array represents a separate split file's parsed content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsedSplitFileContents(String... parsedSplitFileContents);

        /**
         * <p>
         * Returns an array of validation messages generated during EDI validation. These messages provide detailed
         * information about validation errors, warnings, or confirmations based on the configured X12 validation rules
         * such as element length constraints, code list validations, and element requirement checks. This field is
         * populated when the <code>TestParsing</code> API validates EDI documents.
         * </p>
         * 
         * @param validationMessages
         *        Returns an array of validation messages generated during EDI validation. These messages provide
         *        detailed information about validation errors, warnings, or confirmations based on the configured X12
         *        validation rules such as element length constraints, code list validations, and element requirement
         *        checks. This field is populated when the <code>TestParsing</code> API validates EDI documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessages(Collection<String> validationMessages);

        /**
         * <p>
         * Returns an array of validation messages generated during EDI validation. These messages provide detailed
         * information about validation errors, warnings, or confirmations based on the configured X12 validation rules
         * such as element length constraints, code list validations, and element requirement checks. This field is
         * populated when the <code>TestParsing</code> API validates EDI documents.
         * </p>
         * 
         * @param validationMessages
         *        Returns an array of validation messages generated during EDI validation. These messages provide
         *        detailed information about validation errors, warnings, or confirmations based on the configured X12
         *        validation rules such as element length constraints, code list validations, and element requirement
         *        checks. This field is populated when the <code>TestParsing</code> API validates EDI documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessages(String... validationMessages);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String parsedFileContent;

        private List<String> parsedSplitFileContents = DefaultSdkAutoConstructList.getInstance();

        private List<String> validationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestParsingResponse model) {
            super(model);
            parsedFileContent(model.parsedFileContent);
            parsedSplitFileContents(model.parsedSplitFileContents);
            validationMessages(model.validationMessages);
        }

        public final String getParsedFileContent() {
            return parsedFileContent;
        }

        public final void setParsedFileContent(String parsedFileContent) {
            this.parsedFileContent = parsedFileContent;
        }

        @Override
        public final Builder parsedFileContent(String parsedFileContent) {
            this.parsedFileContent = parsedFileContent;
            return this;
        }

        public final Collection<String> getParsedSplitFileContents() {
            if (parsedSplitFileContents instanceof SdkAutoConstructList) {
                return null;
            }
            return parsedSplitFileContents;
        }

        public final void setParsedSplitFileContents(Collection<String> parsedSplitFileContents) {
            this.parsedSplitFileContents = ParsedSplitFileContentsListCopier.copy(parsedSplitFileContents);
        }

        @Override
        public final Builder parsedSplitFileContents(Collection<String> parsedSplitFileContents) {
            this.parsedSplitFileContents = ParsedSplitFileContentsListCopier.copy(parsedSplitFileContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parsedSplitFileContents(String... parsedSplitFileContents) {
            parsedSplitFileContents(Arrays.asList(parsedSplitFileContents));
            return this;
        }

        public final Collection<String> getValidationMessages() {
            if (validationMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return validationMessages;
        }

        public final void setValidationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
        }

        @Override
        public final Builder validationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMessages(String... validationMessages) {
            validationMessages(Arrays.asList(validationMessages));
            return this;
        }

        @Override
        public TestParsingResponse build() {
            return new TestParsingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
