/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the input formatting options for an inbound transformer (takes an X12-formatted EDI document as input and
 * converts it to JSON or XML.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConversion implements SdkPojo, Serializable, ToCopyableBuilder<InputConversion.Builder, InputConversion> {
    private static final SdkField<String> FROM_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromFormat").getter(getter(InputConversion::fromFormatAsString)).setter(setter(Builder::fromFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromFormat").build()).build();

    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField
            .<FormatOptions> builder(MarshallingType.SDK_POJO).memberName("formatOptions")
            .getter(getter(InputConversion::formatOptions)).setter(setter(Builder::formatOptions))
            .constructor(FormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()).build();

    private static final SdkField<AdvancedOptions> ADVANCED_OPTIONS_FIELD = SdkField
            .<AdvancedOptions> builder(MarshallingType.SDK_POJO).memberName("advancedOptions")
            .getter(getter(InputConversion::advancedOptions)).setter(setter(Builder::advancedOptions))
            .constructor(AdvancedOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("advancedOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FORMAT_FIELD,
            FORMAT_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fromFormat;

    private final FormatOptions formatOptions;

    private final AdvancedOptions advancedOptions;

    private InputConversion(BuilderImpl builder) {
        this.fromFormat = builder.fromFormat;
        this.formatOptions = builder.formatOptions;
        this.advancedOptions = builder.advancedOptions;
    }

    /**
     * <p>
     * The format for the transformer input: currently on <code>X12</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fromFormat} will
     * return {@link FromFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fromFormatAsString}.
     * </p>
     * 
     * @return The format for the transformer input: currently on <code>X12</code> is supported.
     * @see FromFormat
     */
    public final FromFormat fromFormat() {
        return FromFormat.fromValue(fromFormat);
    }

    /**
     * <p>
     * The format for the transformer input: currently on <code>X12</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fromFormat} will
     * return {@link FromFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fromFormatAsString}.
     * </p>
     * 
     * @return The format for the transformer input: currently on <code>X12</code> is supported.
     * @see FromFormat
     */
    public final String fromFormatAsString() {
        return fromFormat;
    }

    /**
     * <p>
     * A structure that contains the formatting options for an inbound transformer.
     * </p>
     * 
     * @return A structure that contains the formatting options for an inbound transformer.
     */
    public final FormatOptions formatOptions() {
        return formatOptions;
    }

    /**
     * <p>
     * Specifies advanced options for the input conversion process. These options provide additional control over how
     * EDI files are processed during transformation.
     * </p>
     * 
     * @return Specifies advanced options for the input conversion process. These options provide additional control
     *         over how EDI files are processed during transformation.
     */
    public final AdvancedOptions advancedOptions() {
        return advancedOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(advancedOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConversion)) {
            return false;
        }
        InputConversion other = (InputConversion) obj;
        return Objects.equals(fromFormatAsString(), other.fromFormatAsString())
                && Objects.equals(formatOptions(), other.formatOptions())
                && Objects.equals(advancedOptions(), other.advancedOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConversion").add("FromFormat", fromFormatAsString()).add("FormatOptions", formatOptions())
                .add("AdvancedOptions", advancedOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromFormat":
            return Optional.ofNullable(clazz.cast(fromFormatAsString()));
        case "formatOptions":
            return Optional.ofNullable(clazz.cast(formatOptions()));
        case "advancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fromFormat", FROM_FORMAT_FIELD);
        map.put("formatOptions", FORMAT_OPTIONS_FIELD);
        map.put("advancedOptions", ADVANCED_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputConversion, T> g) {
        return obj -> g.apply((InputConversion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConversion> {
        /**
         * <p>
         * The format for the transformer input: currently on <code>X12</code> is supported.
         * </p>
         * 
         * @param fromFormat
         *        The format for the transformer input: currently on <code>X12</code> is supported.
         * @see FromFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FromFormat
         */
        Builder fromFormat(String fromFormat);

        /**
         * <p>
         * The format for the transformer input: currently on <code>X12</code> is supported.
         * </p>
         * 
         * @param fromFormat
         *        The format for the transformer input: currently on <code>X12</code> is supported.
         * @see FromFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FromFormat
         */
        Builder fromFormat(FromFormat fromFormat);

        /**
         * <p>
         * A structure that contains the formatting options for an inbound transformer.
         * </p>
         * 
         * @param formatOptions
         *        A structure that contains the formatting options for an inbound transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatOptions(FormatOptions formatOptions);

        /**
         * <p>
         * A structure that contains the formatting options for an inbound transformer.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormatOptions.Builder} avoiding the need
         * to create one manually via {@link FormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #formatOptions(FormatOptions)}.
         * 
         * @param formatOptions
         *        a consumer that will call methods on {@link FormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatOptions(FormatOptions)
         */
        default Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return formatOptions(FormatOptions.builder().applyMutation(formatOptions).build());
        }

        /**
         * <p>
         * Specifies advanced options for the input conversion process. These options provide additional control over
         * how EDI files are processed during transformation.
         * </p>
         * 
         * @param advancedOptions
         *        Specifies advanced options for the input conversion process. These options provide additional control
         *        over how EDI files are processed during transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(AdvancedOptions advancedOptions);

        /**
         * <p>
         * Specifies advanced options for the input conversion process. These options provide additional control over
         * how EDI files are processed during transformation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedOptions.Builder} avoiding the
         * need to create one manually via {@link AdvancedOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #advancedOptions(AdvancedOptions)}.
         * 
         * @param advancedOptions
         *        a consumer that will call methods on {@link AdvancedOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedOptions(AdvancedOptions)
         */
        default Builder advancedOptions(Consumer<AdvancedOptions.Builder> advancedOptions) {
            return advancedOptions(AdvancedOptions.builder().applyMutation(advancedOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fromFormat;

        private FormatOptions formatOptions;

        private AdvancedOptions advancedOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConversion model) {
            fromFormat(model.fromFormat);
            formatOptions(model.formatOptions);
            advancedOptions(model.advancedOptions);
        }

        public final String getFromFormat() {
            return fromFormat;
        }

        public final void setFromFormat(String fromFormat) {
            this.fromFormat = fromFormat;
        }

        @Override
        public final Builder fromFormat(String fromFormat) {
            this.fromFormat = fromFormat;
            return this;
        }

        @Override
        public final Builder fromFormat(FromFormat fromFormat) {
            this.fromFormat(fromFormat == null ? null : fromFormat.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return formatOptions != null ? formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final AdvancedOptions.Builder getAdvancedOptions() {
            return advancedOptions != null ? advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptions.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptions advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        @Override
        public InputConversion build() {
            return new InputConversion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
