/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains options for processing inbound EDI files. These options allow for customizing how incoming EDI documents are
 * processed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundEdiOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundEdiOptions.Builder, InboundEdiOptions> {
    private static final SdkField<X12InboundEdiOptions> X12_FIELD = SdkField
            .<X12InboundEdiOptions> builder(MarshallingType.SDK_POJO).memberName("x12").getter(getter(InboundEdiOptions::x12))
            .setter(setter(Builder::x12)).constructor(X12InboundEdiOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12InboundEdiOptions x12;

    private InboundEdiOptions(BuilderImpl builder) {
        this.x12 = builder.x12;
    }

    /**
     * <p>
     * A structure that contains X12-specific options for processing inbound X12 EDI files.
     * </p>
     * 
     * @return A structure that contains X12-specific options for processing inbound X12 EDI files.
     */
    public final X12InboundEdiOptions x12() {
        return x12;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x12());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundEdiOptions)) {
            return false;
        }
        InboundEdiOptions other = (InboundEdiOptions) obj;
        return Objects.equals(x12(), other.x12());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundEdiOptions").add("X12", x12()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "x12":
            return Optional.ofNullable(clazz.cast(x12()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x12", X12_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundEdiOptions, T> g) {
        return obj -> g.apply((InboundEdiOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundEdiOptions> {
        /**
         * <p>
         * A structure that contains X12-specific options for processing inbound X12 EDI files.
         * </p>
         * 
         * @param x12
         *        A structure that contains X12-specific options for processing inbound X12 EDI files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x12(X12InboundEdiOptions x12);

        /**
         * <p>
         * A structure that contains X12-specific options for processing inbound X12 EDI files.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12InboundEdiOptions.Builder} avoiding
         * the need to create one manually via {@link X12InboundEdiOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12InboundEdiOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #x12(X12InboundEdiOptions)}.
         * 
         * @param x12
         *        a consumer that will call methods on {@link X12InboundEdiOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #x12(X12InboundEdiOptions)
         */
        default Builder x12(Consumer<X12InboundEdiOptions.Builder> x12) {
            return x12(X12InboundEdiOptions.builder().applyMutation(x12).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12InboundEdiOptions x12;

        private BuilderImpl() {
        }

        private BuilderImpl(InboundEdiOptions model) {
            x12(model.x12);
        }

        public final X12InboundEdiOptions.Builder getX12() {
            return x12 != null ? x12.toBuilder() : null;
        }

        public final void setX12(X12InboundEdiOptions.BuilderImpl x12) {
            this.x12 = x12 != null ? x12.build() : null;
        }

        @Override
        public final Builder x12(X12InboundEdiOptions x12) {
            this.x12 = x12;
            return this;
        }

        @Override
        public InboundEdiOptions build() {
            return new InboundEdiOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
