/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.b2bi.model.AccessDeniedException;
import software.amazon.awssdk.services.b2bi.model.B2BiException;
import software.amazon.awssdk.services.b2bi.model.ConflictException;
import software.amazon.awssdk.services.b2bi.model.CreateCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.CreateCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.CreatePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.CreatePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.CreateProfileRequest;
import software.amazon.awssdk.services.b2bi.model.CreateProfileResponse;
import software.amazon.awssdk.services.b2bi.model.CreateStarterMappingTemplateRequest;
import software.amazon.awssdk.services.b2bi.model.CreateStarterMappingTemplateResponse;
import software.amazon.awssdk.services.b2bi.model.CreateTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.CreateTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.DeletePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.DeletePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteProfileRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteProfileResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.GenerateMappingRequest;
import software.amazon.awssdk.services.b2bi.model.GenerateMappingResponse;
import software.amazon.awssdk.services.b2bi.model.GetCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.GetCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.GetPartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.GetPartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.GetProfileRequest;
import software.amazon.awssdk.services.b2bi.model.GetProfileResponse;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.model.GetTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.InternalServerException;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse;
import software.amazon.awssdk.services.b2bi.model.ListProfilesRequest;
import software.amazon.awssdk.services.b2bi.model.ListProfilesResponse;
import software.amazon.awssdk.services.b2bi.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.b2bi.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.b2bi.model.ListTransformersRequest;
import software.amazon.awssdk.services.b2bi.model.ListTransformersResponse;
import software.amazon.awssdk.services.b2bi.model.ResourceNotFoundException;
import software.amazon.awssdk.services.b2bi.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.b2bi.model.StartTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.StartTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.model.TagResourceRequest;
import software.amazon.awssdk.services.b2bi.model.TagResourceResponse;
import software.amazon.awssdk.services.b2bi.model.TestConversionRequest;
import software.amazon.awssdk.services.b2bi.model.TestConversionResponse;
import software.amazon.awssdk.services.b2bi.model.TestMappingRequest;
import software.amazon.awssdk.services.b2bi.model.TestMappingResponse;
import software.amazon.awssdk.services.b2bi.model.TestParsingRequest;
import software.amazon.awssdk.services.b2bi.model.TestParsingResponse;
import software.amazon.awssdk.services.b2bi.model.ThrottlingException;
import software.amazon.awssdk.services.b2bi.model.UntagResourceRequest;
import software.amazon.awssdk.services.b2bi.model.UntagResourceResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.UpdatePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.UpdatePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateProfileRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateProfileResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.ValidationException;
import software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable;
import software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable;
import software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable;
import software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable;
import software.amazon.awssdk.services.b2bi.waiters.B2BiWaiter;

/**
 * Service client for accessing AWS B2BI. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i>Amazon Web Services B2B Data Interchange API Reference</i>. It provides descriptions, API request
 * parameters, and the XML response for each of the B2BI API actions.
 * </p>
 * <p>
 * B2BI enables automated exchange of EDI (electronic data interchange) based business-critical transactions at cloud
 * scale, with elasticity and pay-as-you-go pricing. Businesses use EDI documents to exchange transactional data with
 * trading partners, such as suppliers and end customers, using standardized formats such as X12.
 * </p>
 * <note>
 * <p>
 * Rather than actually running a command, you can use the <code>--generate-cli-skeleton</code> parameter with any API
 * call to generate and display a parameter template. You can then use the generated template to customize and use as
 * input on a later command. For details, see <a
 * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-skeleton.html#cli-usage-skeleton-generate">Generate
 * and use a parameter skeleton file</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface B2BiClient extends AwsClient {
    String SERVICE_NAME = "b2bi";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "b2bi";

    /**
     * <p>
     * Instantiates a capability based on the specified parameters. A trading capability contains the information
     * required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param createCapabilityRequest
     * @return Result of the CreateCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCapabilityResponse createCapability(CreateCapabilityRequest createCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates a capability based on the specified parameters. A trading capability contains the information
     * required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCapabilityRequest#builder()}
     * </p>
     *
     * @param createCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateCapabilityRequest.Builder} to create a request.
     * @return Result of the CreateCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCapabilityResponse createCapability(Consumer<CreateCapabilityRequest.Builder> createCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return createCapability(CreateCapabilityRequest.builder().applyMutation(createCapabilityRequest).build());
    }

    /**
     * <p>
     * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership
     * represents the connection between you and your trading partner. It ties together a profile and one or more
     * trading capabilities.
     * </p>
     *
     * @param createPartnershipRequest
     * @return Result of the CreatePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartnershipResponse createPartnership(CreatePartnershipRequest createPartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership
     * represents the connection between you and your trading partner. It ties together a profile and one or more
     * trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartnershipRequest#builder()}
     * </p>
     *
     * @param createPartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreatePartnershipRequest.Builder} to create a request.
     * @return Result of the CreatePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePartnershipResponse createPartnership(Consumer<CreatePartnershipRequest.Builder> createPartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return createPartnership(CreatePartnershipRequest.builder().applyMutation(createPartnershipRequest).build());
    }

    /**
     * <p>
     * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private
     * network. A profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws AccessDeniedException,
            ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private
     * network. A profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateProfileRequest.Builder} to create a request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Amazon Web Services B2B Data Interchange uses a mapping template in JSONata or XSLT format to transform a
     * customer input file into a JSON or XML file that can be converted to EDI.
     * </p>
     * <p>
     * If you provide a sample EDI file with the same structure as the EDI files that you wish to generate, then the
     * service can generate a mapping template. The starter template contains placeholder values which you can replace
     * with JSONata or XSLT expressions to take data from your input file and insert it into the JSON or XML file that
     * is used to generate the EDI.
     * </p>
     * <p>
     * If you do not provide a sample EDI file, then the service can generate a mapping template based on the EDI
     * settings in the <code>templateDetails</code> parameter.
     * </p>
     * <p>
     * Currently, we only support generating a template that can generate the input to produce an Outbound X12 EDI file.
     * </p>
     *
     * @param createStarterMappingTemplateRequest
     * @return Result of the CreateStarterMappingTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateStarterMappingTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateStarterMappingTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStarterMappingTemplateResponse createStarterMappingTemplate(
            CreateStarterMappingTemplateRequest createStarterMappingTemplateRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Amazon Web Services B2B Data Interchange uses a mapping template in JSONata or XSLT format to transform a
     * customer input file into a JSON or XML file that can be converted to EDI.
     * </p>
     * <p>
     * If you provide a sample EDI file with the same structure as the EDI files that you wish to generate, then the
     * service can generate a mapping template. The starter template contains placeholder values which you can replace
     * with JSONata or XSLT expressions to take data from your input file and insert it into the JSON or XML file that
     * is used to generate the EDI.
     * </p>
     * <p>
     * If you do not provide a sample EDI file, then the service can generate a mapping template based on the EDI
     * settings in the <code>templateDetails</code> parameter.
     * </p>
     * <p>
     * Currently, we only support generating a template that can generate the input to produce an Outbound X12 EDI file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStarterMappingTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStarterMappingTemplateRequest#builder()}
     * </p>
     *
     * @param createStarterMappingTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateStarterMappingTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStarterMappingTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateStarterMappingTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateStarterMappingTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStarterMappingTemplateResponse createStarterMappingTemplate(
            Consumer<CreateStarterMappingTemplateRequest.Builder> createStarterMappingTemplateRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, B2BiException {
        return createStarterMappingTemplate(CreateStarterMappingTemplateRequest.builder()
                .applyMutation(createStarterMappingTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a transformer. Amazon Web Services B2B Data Interchange currently supports two scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Inbound EDI</i>: the Amazon Web Services customer receives an EDI file from their trading partner. Amazon Web
     * Services B2B Data Interchange converts this EDI file into a JSON or XML file with a service-defined structure. A
     * mapping template provided by the customer, in JSONata or XSLT format, is optionally applied to this file to
     * produce a JSON or XML file with the structure the customer requires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Outbound EDI</i>: the Amazon Web Services customer has a JSON or XML file containing data that they wish to
     * use in an EDI file. A mapping template, provided by the customer (in either JSONata or XSLT format) is applied to
     * this file to generate a JSON or XML file in the service-defined structure. This file is then converted to an EDI
     * file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The following fields are provided for backwards compatibility only: <code>fileFormat</code>,
     * <code>mappingTemplate</code>, <code>ediType</code>, and <code>sampleDocument</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>mapping</code> data type in place of <code>mappingTemplate</code> and <code>fileFormat</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>sampleDocuments</code> data type in place of <code>sampleDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Use either the <code>inputConversion</code> or <code>outputConversion</code> in place of <code>ediType</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createTransformerRequest
     * @return Result of the CreateTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTransformerResponse createTransformer(CreateTransformerRequest createTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transformer. Amazon Web Services B2B Data Interchange currently supports two scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Inbound EDI</i>: the Amazon Web Services customer receives an EDI file from their trading partner. Amazon Web
     * Services B2B Data Interchange converts this EDI file into a JSON or XML file with a service-defined structure. A
     * mapping template provided by the customer, in JSONata or XSLT format, is optionally applied to this file to
     * produce a JSON or XML file with the structure the customer requires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Outbound EDI</i>: the Amazon Web Services customer has a JSON or XML file containing data that they wish to
     * use in an EDI file. A mapping template, provided by the customer (in either JSONata or XSLT format) is applied to
     * this file to generate a JSON or XML file in the service-defined structure. This file is then converted to an EDI
     * file.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The following fields are provided for backwards compatibility only: <code>fileFormat</code>,
     * <code>mappingTemplate</code>, <code>ediType</code>, and <code>sampleDocument</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>mapping</code> data type in place of <code>mappingTemplate</code> and <code>fileFormat</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>sampleDocuments</code> data type in place of <code>sampleDocument</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Use either the <code>inputConversion</code> or <code>outputConversion</code> in place of <code>ediType</code>
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTransformerRequest#builder()}
     * </p>
     *
     * @param createTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateTransformerRequest.Builder} to create a request.
     * @return Result of the CreateTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.CreateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTransformerResponse createTransformer(Consumer<CreateTransformerRequest.Builder> createTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return createTransformer(CreateTransformerRequest.builder().applyMutation(createTransformerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified capability. A trading capability contains the information required to transform incoming
     * EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param deleteCapabilityRequest
     * @return Result of the DeleteCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCapabilityResponse deleteCapability(DeleteCapabilityRequest deleteCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified capability. A trading capability contains the information required to transform incoming
     * EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCapabilityRequest#builder()}
     * </p>
     *
     * @param deleteCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteCapabilityRequest.Builder} to create a request.
     * @return Result of the DeleteCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCapabilityResponse deleteCapability(Consumer<DeleteCapabilityRequest.Builder> deleteCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return deleteCapability(DeleteCapabilityRequest.builder().applyMutation(deleteCapabilityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified partnership. A partnership represents the connection between you and your trading partner.
     * It ties together a profile and one or more trading capabilities.
     * </p>
     *
     * @param deletePartnershipRequest
     * @return Result of the DeletePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeletePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartnershipResponse deletePartnership(DeletePartnershipRequest deletePartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified partnership. A partnership represents the connection between you and your trading partner.
     * It ties together a profile and one or more trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartnershipRequest#builder()}
     * </p>
     *
     * @param deletePartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeletePartnershipRequest.Builder} to create a request.
     * @return Result of the DeletePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeletePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePartnershipResponse deletePartnership(Consumer<DeletePartnershipRequest.Builder> deletePartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return deletePartnership(DeletePartnershipRequest.builder().applyMutation(deletePartnershipRequest).build());
    }

    /**
     * <p>
     * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws ConflictException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteProfileRequest.Builder} to create a request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws ConflictException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transformer. A transformer can take an EDI file as input and transform it into a JSON-or
     * XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and
     * transform it into an EDI file.
     * </p>
     *
     * @param deleteTransformerRequest
     * @return Result of the DeleteTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTransformerResponse deleteTransformer(DeleteTransformerRequest deleteTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transformer. A transformer can take an EDI file as input and transform it into a JSON-or
     * XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and
     * transform it into an EDI file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTransformerRequest#builder()}
     * </p>
     *
     * @param deleteTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteTransformerRequest.Builder} to create a request.
     * @return Result of the DeleteTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTransformerResponse deleteTransformer(Consumer<DeleteTransformerRequest.Builder> deleteTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return deleteTransformer(DeleteTransformerRequest.builder().applyMutation(deleteTransformerRequest).build());
    }

    /**
     * <p>
     * Takes sample input and output documents and uses Amazon Bedrock to generate a mapping automatically. Depending on
     * the accuracy and other factors, you can then edit the mapping for your needs.
     * </p>
     * <note>
     * <p>
     * Before you can use the AI-assisted feature for Amazon Web Services B2B Data Interchange you must enable models in
     * Amazon Bedrock. For details, see <a
     * href="https://docs.aws.amazon.com/b2bi/latest/userguide/ai-assisted-mapping.html#ai-assist-prereq">AI-assisted
     * template mapping prerequisites</a> in the <i>Amazon Web Services B2B Data Interchange User guide</i>.
     * </p>
     * </note>
     * <p>
     * To generate a mapping, perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Start with an X12 EDI document to use as the input.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>TestMapping</code> using your EDI document.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the output from the <code>TestMapping</code> operation as either input or output for your GenerateMapping
     * call, along with your sample file.
     * </p>
     * </li>
     * </ol>
     *
     * @param generateMappingRequest
     * @return Result of the GenerateMapping operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GenerateMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GenerateMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default GenerateMappingResponse generateMapping(GenerateMappingRequest generateMappingRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes sample input and output documents and uses Amazon Bedrock to generate a mapping automatically. Depending on
     * the accuracy and other factors, you can then edit the mapping for your needs.
     * </p>
     * <note>
     * <p>
     * Before you can use the AI-assisted feature for Amazon Web Services B2B Data Interchange you must enable models in
     * Amazon Bedrock. For details, see <a
     * href="https://docs.aws.amazon.com/b2bi/latest/userguide/ai-assisted-mapping.html#ai-assist-prereq">AI-assisted
     * template mapping prerequisites</a> in the <i>Amazon Web Services B2B Data Interchange User guide</i>.
     * </p>
     * </note>
     * <p>
     * To generate a mapping, perform the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Start with an X12 EDI document to use as the input.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>TestMapping</code> using your EDI document.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the output from the <code>TestMapping</code> operation as either input or output for your GenerateMapping
     * call, along with your sample file.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateMappingRequest.Builder} avoiding the need
     * to create one manually via {@link GenerateMappingRequest#builder()}
     * </p>
     *
     * @param generateMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GenerateMappingRequest.Builder} to create a request.
     * @return Result of the GenerateMapping operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GenerateMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GenerateMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default GenerateMappingResponse generateMapping(Consumer<GenerateMappingRequest.Builder> generateMappingRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return generateMapping(GenerateMappingRequest.builder().applyMutation(generateMappingRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the specified capability. A trading capability contains the information required to
     * transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param getCapabilityRequest
     * @return Result of the GetCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCapabilityResponse getCapability(GetCapabilityRequest getCapabilityRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the specified capability. A trading capability contains the information required to
     * transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCapabilityRequest.Builder} avoiding the need to
     * create one manually via {@link GetCapabilityRequest#builder()}
     * </p>
     *
     * @param getCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetCapabilityRequest.Builder} to create a request.
     * @return Result of the GetCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCapabilityResponse getCapability(Consumer<GetCapabilityRequest.Builder> getCapabilityRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return getCapability(GetCapabilityRequest.builder().applyMutation(getCapabilityRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     *
     * @param getPartnershipRequest
     * @return Result of the GetPartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetPartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartnershipResponse getPartnership(GetPartnershipRequest getPartnershipRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnershipRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartnershipRequest#builder()}
     * </p>
     *
     * @param getPartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetPartnershipRequest.Builder} to create a request.
     * @return Result of the GetPartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetPartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartnershipResponse getPartnership(Consumer<GetPartnershipRequest.Builder> getPartnershipRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return getPartnership(GetPartnershipRequest.builder().applyMutation(getPartnershipRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the
     * concept of a private network.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the
     * concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetProfileRequest.Builder} to create a request.
     * @return Result of the GetProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the transformer specified by the transformer ID. A transformer can take an EDI file as
     * input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or
     * XML-formatted document as input and transform it into an EDI file.
     * </p>
     *
     * @param getTransformerRequest
     * @return Result of the GetTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTransformerResponse getTransformer(GetTransformerRequest getTransformerRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the transformer specified by the transformer ID. A transformer can take an EDI file as
     * input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or
     * XML-formatted document as input and transform it into an EDI file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransformerRequest.Builder} avoiding the need to
     * create one manually via {@link GetTransformerRequest#builder()}
     * </p>
     *
     * @param getTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetTransformerRequest.Builder} to create a request.
     * @return Result of the GetTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTransformerResponse getTransformer(Consumer<GetTransformerRequest.Builder> getTransformerRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return getTransformer(GetTransformerRequest.builder().applyMutation(getTransformerRequest).build());
    }

    /**
     * <p>
     * Returns the details of the transformer run, based on the Transformer job ID.
     * </p>
     * <note>
     * <p>
     * If 30 days have elapsed since your transformer job was started, the system deletes it. So, if you run
     * <code>GetTransformerJob</code> and supply a <code>transformerId</code> and <code>transformerJobId</code> for a
     * job that was started more than 30 days previously, you receive a 404 response.
     * </p>
     * </note>
     *
     * @param getTransformerJobRequest
     * @return Result of the GetTransformerJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTransformerJobResponse getTransformerJob(GetTransformerJobRequest getTransformerJobRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the transformer run, based on the Transformer job ID.
     * </p>
     * <note>
     * <p>
     * If 30 days have elapsed since your transformer job was started, the system deletes it. So, if you run
     * <code>GetTransformerJob</code> and supply a <code>transformerId</code> and <code>transformerJobId</code> for a
     * job that was started more than 30 days previously, you receive a 404 response.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransformerJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetTransformerJobRequest#builder()}
     * </p>
     *
     * @param getTransformerJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest.Builder} to create a request.
     * @return Result of the GetTransformerJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.GetTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTransformerJobResponse getTransformerJob(Consumer<GetTransformerJobRequest.Builder> getTransformerJobRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return getTransformerJob(GetTransformerJobRequest.builder().applyMutation(getTransformerJobRequest).build());
    }

    /**
     * <p>
     * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A
     * trading capability contains the information required to transform incoming EDI documents into JSON or XML
     * outputs.
     * </p>
     *
     * @param listCapabilitiesRequest
     * @return Result of the ListCapabilities operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesResponse listCapabilities(ListCapabilitiesRequest listCapabilitiesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A
     * trading capability contains the information required to transform incoming EDI documents into JSON or XML
     * outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapabilitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapabilitiesRequest#builder()}
     * </p>
     *
     * @param listCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest.Builder} to create a request.
     * @return Result of the ListCapabilities operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesResponse listCapabilities(Consumer<ListCapabilitiesRequest.Builder> listCapabilitiesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listCapabilities(ListCapabilitiesRequest.builder().applyMutation(listCapabilitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client.listCapabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client
     *             .listCapabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client.listCapabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation.</b>
     * </p>
     *
     * @param listCapabilitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesIterable listCapabilitiesPaginator(ListCapabilitiesRequest listCapabilitiesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return new ListCapabilitiesIterable(this, listCapabilitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client.listCapabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client
     *             .listCapabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesIterable responses = client.listCapabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapabilitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapabilitiesRequest#builder()}
     * </p>
     *
     * @param listCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesIterable listCapabilitiesPaginator(Consumer<ListCapabilitiesRequest.Builder> listCapabilitiesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listCapabilitiesPaginator(ListCapabilitiesRequest.builder().applyMutation(listCapabilitiesRequest).build());
    }

    /**
     * <p>
     * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A
     * partnership represents the connection between you and your trading partner. It ties together a profile and one or
     * more trading capabilities.
     * </p>
     *
     * @param listPartnershipsRequest
     * @return Result of the ListPartnerships operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsResponse listPartnerships(ListPartnershipsRequest listPartnershipsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A
     * partnership represents the connection between you and your trading partner. It ties together a profile and one or
     * more trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPartnershipsRequest#builder()}
     * </p>
     *
     * @param listPartnershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest.Builder} to create a request.
     * @return Result of the ListPartnerships operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsResponse listPartnerships(Consumer<ListPartnershipsRequest.Builder> listPartnershipsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return listPartnerships(ListPartnershipsRequest.builder().applyMutation(listPartnershipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client.listPartnershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client
     *             .listPartnershipsPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client.listPartnershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation.</b>
     * </p>
     *
     * @param listPartnershipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsIterable listPartnershipsPaginator(ListPartnershipsRequest listPartnershipsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return new ListPartnershipsIterable(this, listPartnershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client.listPartnershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client
     *             .listPartnershipsPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsIterable responses = client.listPartnershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPartnershipsRequest#builder()}
     * </p>
     *
     * @param listPartnershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsIterable listPartnershipsPaginator(Consumer<ListPartnershipsRequest.Builder> listPartnershipsRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return listPartnershipsPaginator(ListPartnershipsRequest.builder().applyMutation(listPartnershipsRequest).build());
    }

    /**
     * <p>
     * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A
     * profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param listProfilesRequest
     * @return Result of the ListProfiles operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesResponse listProfiles(ListProfilesRequest listProfilesRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A
     * profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListProfilesRequest.Builder} to create a request.
     * @return Result of the ListProfiles operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesResponse listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(ListProfilesRequest listProfilesRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        return new ListProfilesIterable(this, listProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListProfilesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * capability, partnership, profile, or transformer.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * capability, partnership, profile, or transformer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the available transformers. A transformer can take an EDI file as input and transform it into a JSON-or
     * XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and
     * transform it into an EDI file.
     * </p>
     *
     * @param listTransformersRequest
     * @return Result of the ListTransformers operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersResponse listTransformers(ListTransformersRequest listTransformersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available transformers. A transformer can take an EDI file as input and transform it into a JSON-or
     * XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and
     * transform it into an EDI file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformersRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformersRequest#builder()}
     * </p>
     *
     * @param listTransformersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTransformersRequest.Builder} to create a request.
     * @return Result of the ListTransformers operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersResponse listTransformers(Consumer<ListTransformersRequest.Builder> listTransformersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listTransformers(ListTransformersRequest.builder().applyMutation(listTransformersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client.listTransformersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client
     *             .listTransformersPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListTransformersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client.listTransformersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation.</b>
     * </p>
     *
     * @param listTransformersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersIterable listTransformersPaginator(ListTransformersRequest listTransformersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return new ListTransformersIterable(this, listTransformersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client.listTransformersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client
     *             .listTransformersPaginator(request);
     *     for (software.amazon.awssdk.services.b2bi.model.ListTransformersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersIterable responses = client.listTransformersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformersRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformersRequest#builder()}
     * </p>
     *
     * @param listTransformersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTransformersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersIterable listTransformersPaginator(Consumer<ListTransformersRequest.Builder> listTransformersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return listTransformersPaginator(ListTransformersRequest.builder().applyMutation(listTransformersRequest).build());
    }

    /**
     * <p>
     * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures
     * used by Amazon Web Services B2B Data Interchange.
     * </p>
     * <p>
     * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles,
     * partnerships or capabilities. Just create and configure a transformer, and then run the
     * <code>StartTransformerJob</code> API to process your files.
     * </p>
     * <note>
     * <p>
     * The system stores transformer jobs for 30 days. During that period, you can run <a
     * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformerJob.html">GetTransformerJob</a> and
     * supply its <code>transformerId</code> and <code>transformerJobId</code> to return details of the job.
     * </p>
     * </note>
     *
     * @param startTransformerJobRequest
     * @return Result of the StartTransformerJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.StartTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTransformerJobResponse startTransformerJob(StartTransformerJobRequest startTransformerJobRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures
     * used by Amazon Web Services B2B Data Interchange.
     * </p>
     * <p>
     * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles,
     * partnerships or capabilities. Just create and configure a transformer, and then run the
     * <code>StartTransformerJob</code> API to process your files.
     * </p>
     * <note>
     * <p>
     * The system stores transformer jobs for 30 days. During that period, you can run <a
     * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformerJob.html">GetTransformerJob</a> and
     * supply its <code>transformerId</code> and <code>transformerJobId</code> to return details of the job.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTransformerJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartTransformerJobRequest#builder()}
     * </p>
     *
     * @param startTransformerJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.StartTransformerJobRequest.Builder} to create a request.
     * @return Result of the StartTransformerJob operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.StartTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTransformerJobResponse startTransformerJob(
            Consumer<StartTransformerJobRequest.Builder> startTransformerJobRequest) throws AccessDeniedException,
            ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, B2BiException {
        return startTransformerJob(StartTransformerJobRequest.builder().applyMutation(startTransformerJobRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are
     * capability, partnership, profile, transformers and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are
     * capability, partnership, profile, transformers and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            B2BiException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * This operation mimics the latter half of a typical Outbound EDI request. It takes an input JSON/XML in the B2Bi
     * shape as input, converts it to an X12 EDI string, and return that string.
     * </p>
     *
     * @param testConversionRequest
     * @return Result of the TestConversion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestConversion" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConversionResponse testConversion(TestConversionRequest testConversionRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation mimics the latter half of a typical Outbound EDI request. It takes an input JSON/XML in the B2Bi
     * shape as input, converts it to an X12 EDI string, and return that string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestConversionRequest.Builder} avoiding the need to
     * create one manually via {@link TestConversionRequest#builder()}
     * </p>
     *
     * @param testConversionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TestConversionRequest.Builder} to create a request.
     * @return Result of the TestConversion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestConversion" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConversionResponse testConversion(Consumer<TestConversionRequest.Builder> testConversionRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return testConversion(TestConversionRequest.builder().applyMutation(testConversionRequest).build());
    }

    /**
     * <p>
     * Maps the input file according to the provided template file. The API call downloads the file contents from the
     * Amazon S3 location, and passes the contents in as a string, to the <code>inputFileContent</code> parameter.
     * </p>
     *
     * @param testMappingRequest
     * @return Result of the TestMapping operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default TestMappingResponse testMapping(TestMappingRequest testMappingRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps the input file according to the provided template file. The API call downloads the file contents from the
     * Amazon S3 location, and passes the contents in as a string, to the <code>inputFileContent</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestMappingRequest.Builder} avoiding the need to
     * create one manually via {@link TestMappingRequest#builder()}
     * </p>
     *
     * @param testMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TestMappingRequest.Builder} to create a request.
     * @return Result of the TestMapping operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default TestMappingResponse testMapping(Consumer<TestMappingRequest.Builder> testMappingRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return testMapping(TestMappingRequest.builder().applyMutation(testMappingRequest).build());
    }

    /**
     * <p>
     * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
     * </p>
     *
     * @param testParsingRequest
     * @return Result of the TestParsing operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestParsing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing" target="_top">AWS API
     *      Documentation</a>
     */
    default TestParsingResponse testParsing(TestParsingRequest testParsingRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestParsingRequest.Builder} avoiding the need to
     * create one manually via {@link TestParsingRequest#builder()}
     * </p>
     *
     * @param testParsingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TestParsingRequest.Builder} to create a request.
     * @return Result of the TestParsing operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.TestParsing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing" target="_top">AWS API
     *      Documentation</a>
     */
    default TestParsingResponse testParsing(Consumer<TestParsingRequest.Builder> testParsingRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return testParsing(TestParsingRequest.builder().applyMutation(testParsingRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources
     * are capability, partnership, profile, transformers and other entities.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources
     * are capability, partnership, profile, transformers and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, B2BiException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains
     * the information required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param updateCapabilityRequest
     * @return Result of the UpdateCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCapabilityResponse updateCapability(UpdateCapabilityRequest updateCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains
     * the information required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCapabilityRequest#builder()}
     * </p>
     *
     * @param updateCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateCapabilityRequest.Builder} to create a request.
     * @return Result of the UpdateCapability operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCapabilityResponse updateCapability(Consumer<UpdateCapabilityRequest.Builder> updateCapabilityRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ThrottlingException, ResourceNotFoundException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return updateCapability(UpdateCapabilityRequest.builder().applyMutation(updateCapabilityRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     *
     * @param updatePartnershipRequest
     * @return Result of the UpdatePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePartnershipResponse updatePartnership(UpdatePartnershipRequest updatePartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePartnershipRequest#builder()}
     * </p>
     *
     * @param updatePartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdatePartnershipRequest.Builder} to create a request.
     * @return Result of the UpdatePartnership operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePartnershipResponse updatePartnership(Consumer<UpdatePartnershipRequest.Builder> updatePartnershipRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return updatePartnership(UpdatePartnershipRequest.builder().applyMutation(updatePartnershipRequest).build());
    }

    /**
     * <p>
     * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a
     * private network.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws AccessDeniedException,
            ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a
     * private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateProfileRequest.Builder} to create a request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates the specified parameters for a transformer. A transformer can take an EDI file as input and transform it
     * into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as
     * input and transform it into an EDI file.
     * </p>
     *
     * @param updateTransformerRequest
     * @return Result of the UpdateTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTransformerResponse updateTransformer(UpdateTransformerRequest updateTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified parameters for a transformer. A transformer can take an EDI file as input and transform it
     * into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as
     * input and transform it into an EDI file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTransformerRequest#builder()}
     * </p>
     *
     * @param updateTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateTransformerRequest.Builder} to create a request.
     * @return Result of the UpdateTransformer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ConflictException
     *         A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability)
     *         that is being used by other resources.
     * @throws ValidationException
     *         Occurs when a B2BI object cannot be validated against a request from another object. This exception can
     *         be thrown during standard EDI validation or when custom validation rules fail, such as when element
     *         length constraints are violated, invalid codes are used in code list validations, or required elements
     *         are missing based on configured element requirement rules.
     * @throws ResourceNotFoundException
     *         Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists
     *         in a region other than the region specified in the API call.
     * @throws ThrottlingException
     *         The request was denied due to throttling: the data speed and rendering may be limited depending on
     *         various parameters and conditions.
     * @throws ServiceQuotaExceededException
     *         Occurs when the calling command attempts to exceed one of the service quotas, for example trying to
     *         create a capability when you already have the maximum number of capabilities allowed.
     * @throws InternalServerException
     *         This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws B2BiException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample B2BiClient.UpdateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTransformerResponse updateTransformer(Consumer<UpdateTransformerRequest.Builder> updateTransformerRequest)
            throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, B2BiException {
        return updateTransformer(UpdateTransformerRequest.builder().applyMutation(updateTransformerRequest).build());
    }

    /**
     * Create an instance of {@link B2BiWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link B2BiWaiter}
     */
    default B2BiWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link B2BiClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static B2BiClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link B2BiClient}.
     */
    static B2BiClientBuilder builder() {
        return new DefaultB2BiClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default B2BiServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
