/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.ElementRequirement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12ElementRequirementValidationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12ElementRequirementValidationRule> {
    private static final SdkField<String> ELEMENT_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("elementPosition").getter(X12ElementRequirementValidationRule.getter(X12ElementRequirementValidationRule::elementPosition)).setter(X12ElementRequirementValidationRule.setter(Builder::elementPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementPosition").build()}).build();
    private static final SdkField<String> REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requirement").getter(X12ElementRequirementValidationRule.getter(X12ElementRequirementValidationRule::requirementAsString)).setter(X12ElementRequirementValidationRule.setter(Builder::requirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requirement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_POSITION_FIELD, REQUIREMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12ElementRequirementValidationRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String elementPosition;
    private final String requirement;

    private X12ElementRequirementValidationRule(BuilderImpl builder) {
        this.elementPosition = builder.elementPosition;
        this.requirement = builder.requirement;
    }

    public final String elementPosition() {
        return this.elementPosition;
    }

    public final ElementRequirement requirement() {
        return ElementRequirement.fromValue(this.requirement);
    }

    public final String requirementAsString() {
        return this.requirement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ElementRequirementValidationRule)) {
            return false;
        }
        X12ElementRequirementValidationRule other = (X12ElementRequirementValidationRule)obj;
        return Objects.equals(this.elementPosition(), other.elementPosition()) && Objects.equals(this.requirementAsString(), other.requirementAsString());
    }

    public final String toString() {
        return ToString.builder((String)"X12ElementRequirementValidationRule").add("ElementPosition", (Object)this.elementPosition()).add("Requirement", (Object)this.requirementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elementPosition": {
                return Optional.ofNullable(clazz.cast(this.elementPosition()));
            }
            case "requirement": {
                return Optional.ofNullable(clazz.cast(this.requirementAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("elementPosition", ELEMENT_POSITION_FIELD);
        map.put("requirement", REQUIREMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ElementRequirementValidationRule, T> g) {
        return obj -> g.apply((X12ElementRequirementValidationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementPosition;
        private String requirement;

        private BuilderImpl() {
        }

        private BuilderImpl(X12ElementRequirementValidationRule model) {
            this.elementPosition(model.elementPosition);
            this.requirement(model.requirement);
        }

        public final String getElementPosition() {
            return this.elementPosition;
        }

        public final void setElementPosition(String elementPosition) {
            this.elementPosition = elementPosition;
        }

        @Override
        public final Builder elementPosition(String elementPosition) {
            this.elementPosition = elementPosition;
            return this;
        }

        public final String getRequirement() {
            return this.requirement;
        }

        public final void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        @Override
        public final Builder requirement(String requirement) {
            this.requirement = requirement;
            return this;
        }

        @Override
        public final Builder requirement(ElementRequirement requirement) {
            this.requirement(requirement == null ? null : requirement.toString());
            return this;
        }

        public X12ElementRequirementValidationRule build() {
            return new X12ElementRequirementValidationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12ElementRequirementValidationRule> {
        public Builder elementPosition(String var1);

        public Builder requirement(String var1);

        public Builder requirement(ElementRequirement var1);
    }
}

