/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProfileRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, UpdateProfileRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(UpdateProfileRequest.getter(UpdateProfileRequest::profileId)).setter(UpdateProfileRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateProfileRequest.getter(UpdateProfileRequest::name)).setter(UpdateProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(UpdateProfileRequest.getter(UpdateProfileRequest::email)).setter(UpdateProfileRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> PHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phone").getter(UpdateProfileRequest.getter(UpdateProfileRequest::phone)).setter(UpdateProfileRequest.setter(Builder::phone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()}).build();
    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("businessName").getter(UpdateProfileRequest.getter(UpdateProfileRequest::businessName)).setter(UpdateProfileRequest.setter(Builder::businessName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, NAME_FIELD, EMAIL_FIELD, PHONE_FIELD, BUSINESS_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProfileRequest.memberNameToFieldInitializer();
    private final String profileId;
    private final String name;
    private final String email;
    private final String phone;
    private final String businessName;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.businessName = builder.businessName;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String name() {
        return this.name;
    }

    public final String email() {
        return this.email;
    }

    public final String phone() {
        return this.phone;
    }

    public final String businessName() {
        return this.businessName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.phone());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest)((Object)obj);
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.phone(), other.phone()) && Objects.equals(this.businessName(), other.businessName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProfileRequest").add("ProfileId", (Object)this.profileId()).add("Name", (Object)this.name()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("Phone", (Object)(this.phone() == null ? null : "*** Sensitive Data Redacted ***")).add("BusinessName", (Object)this.businessName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "phone": {
                return Optional.ofNullable(clazz.cast(this.phone()));
            }
            case "businessName": {
                return Optional.ofNullable(clazz.cast(this.businessName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("phone", PHONE_FIELD);
        map.put("businessName", BUSINESS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String profileId;
        private String name;
        private String email;
        private String phone;
        private String businessName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            this.profileId(model.profileId);
            this.name(model.name);
            this.email(model.email);
            this.phone(model.phone);
            this.businessName(model.businessName);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return this.phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final String getBusinessName() {
            return this.businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProfileRequest> {
        public Builder profileId(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder phone(String var1);

        public Builder businessName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

