/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.AdvancedOptions;
import software.amazon.awssdk.services.b2bi.model.FormatOptions;
import software.amazon.awssdk.services.b2bi.model.ToFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputConversion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputConversion> {
    private static final SdkField<String> TO_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toFormat").getter(OutputConversion.getter(OutputConversion::toFormatAsString)).setter(OutputConversion.setter(Builder::toFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toFormat").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatOptions").getter(OutputConversion.getter(OutputConversion::formatOptions)).setter(OutputConversion.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()}).build();
    private static final SdkField<AdvancedOptions> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("advancedOptions").getter(OutputConversion.getter(OutputConversion::advancedOptions)).setter(OutputConversion.setter(Builder::advancedOptions)).constructor(AdvancedOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("advancedOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_FORMAT_FIELD, FORMAT_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputConversion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String toFormat;
    private final FormatOptions formatOptions;
    private final AdvancedOptions advancedOptions;

    private OutputConversion(BuilderImpl builder) {
        this.toFormat = builder.toFormat;
        this.formatOptions = builder.formatOptions;
        this.advancedOptions = builder.advancedOptions;
    }

    public final ToFormat toFormat() {
        return ToFormat.fromValue(this.toFormat);
    }

    public final String toFormatAsString() {
        return this.toFormat;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final AdvancedOptions advancedOptions() {
        return this.advancedOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConversion)) {
            return false;
        }
        OutputConversion other = (OutputConversion)obj;
        return Objects.equals(this.toFormatAsString(), other.toFormatAsString()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions());
    }

    public final String toString() {
        return ToString.builder((String)"OutputConversion").add("ToFormat", (Object)this.toFormatAsString()).add("FormatOptions", (Object)this.formatOptions()).add("AdvancedOptions", (Object)this.advancedOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toFormat": {
                return Optional.ofNullable(clazz.cast(this.toFormatAsString()));
            }
            case "formatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "advancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("toFormat", TO_FORMAT_FIELD);
        map.put("formatOptions", FORMAT_OPTIONS_FIELD);
        map.put("advancedOptions", ADVANCED_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputConversion, T> g) {
        return obj -> g.apply((OutputConversion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String toFormat;
        private FormatOptions formatOptions;
        private AdvancedOptions advancedOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConversion model) {
            this.toFormat(model.toFormat);
            this.formatOptions(model.formatOptions);
            this.advancedOptions(model.advancedOptions);
        }

        public final String getToFormat() {
            return this.toFormat;
        }

        public final void setToFormat(String toFormat) {
            this.toFormat = toFormat;
        }

        @Override
        public final Builder toFormat(String toFormat) {
            this.toFormat = toFormat;
            return this;
        }

        @Override
        public final Builder toFormat(ToFormat toFormat) {
            this.toFormat(toFormat == null ? null : toFormat.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final AdvancedOptions.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        public final void setAdvancedOptions(AdvancedOptions.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptions advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public OutputConversion build() {
            return new OutputConversion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputConversion> {
        public Builder toFormat(String var1);

        public Builder toFormat(ToFormat var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder advancedOptions(AdvancedOptions var1);

        default public Builder advancedOptions(Consumer<AdvancedOptions.Builder> advancedOptions) {
            return this.advancedOptions((AdvancedOptions)((AdvancedOptions.Builder)AdvancedOptions.builder().applyMutation(advancedOptions)).build());
        }
    }
}

