/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.PartnershipListCopier;
import software.amazon.awssdk.services.b2bi.model.PartnershipSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnershipsResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, ListPartnershipsResponse> {
    private static final SdkField<List<PartnershipSummary>> PARTNERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partnerships").getter(ListPartnershipsResponse.getter(ListPartnershipsResponse::partnerships)).setter(ListPartnershipsResponse.setter(Builder::partnerships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnershipSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPartnershipsResponse.getter(ListPartnershipsResponse::nextToken)).setter(ListPartnershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNERSHIPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("partnerships", PARTNERSHIPS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PartnershipSummary> partnerships;
    private final String nextToken;

    private ListPartnershipsResponse(BuilderImpl builder) {
        super(builder);
        this.partnerships = builder.partnerships;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPartnerships() {
        return this.partnerships != null && !(this.partnerships instanceof SdkAutoConstructList);
    }

    public final List<PartnershipSummary> partnerships() {
        return this.partnerships;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerships() ? this.partnerships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnershipsResponse)) {
            return false;
        }
        ListPartnershipsResponse other = (ListPartnershipsResponse)((Object)obj);
        return this.hasPartnerships() == other.hasPartnerships() && Objects.equals(this.partnerships(), other.partnerships()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartnershipsResponse").add("Partnerships", this.hasPartnerships() ? this.partnerships() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "partnerships": {
                return Optional.ofNullable(clazz.cast(this.partnerships()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPartnershipsResponse, T> g) {
        return obj -> g.apply((ListPartnershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private List<PartnershipSummary> partnerships = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnershipsResponse model) {
            super(model);
            this.partnerships(model.partnerships);
            this.nextToken(model.nextToken);
        }

        public final List<PartnershipSummary.Builder> getPartnerships() {
            List<PartnershipSummary.Builder> result = PartnershipListCopier.copyToBuilder(this.partnerships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerships(Collection<PartnershipSummary.BuilderImpl> partnerships) {
            this.partnerships = PartnershipListCopier.copyFromBuilder(partnerships);
        }

        @Override
        public final Builder partnerships(Collection<PartnershipSummary> partnerships) {
            this.partnerships = PartnershipListCopier.copy(partnerships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerships(PartnershipSummary ... partnerships) {
            this.partnerships(Arrays.asList(partnerships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerships(Consumer<PartnershipSummary.Builder> ... partnerships) {
            this.partnerships(Stream.of(partnerships).map(c -> (PartnershipSummary)((PartnershipSummary.Builder)PartnershipSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnershipsResponse build() {
            return new ListPartnershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnershipsResponse> {
        public Builder partnerships(Collection<PartnershipSummary> var1);

        public Builder partnerships(PartnershipSummary ... var1);

        public Builder partnerships(Consumer<PartnershipSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

