/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.FormatOptions;
import software.amazon.awssdk.services.b2bi.model.FromFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputConversion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputConversion> {
    private static final SdkField<String> FROM_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromFormat").getter(InputConversion.getter(InputConversion::fromFormatAsString)).setter(InputConversion.setter(Builder::fromFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromFormat").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatOptions").getter(InputConversion.getter(InputConversion::formatOptions)).setter(InputConversion.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FORMAT_FIELD, FORMAT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fromFormat", FROM_FORMAT_FIELD);
            this.put("formatOptions", FORMAT_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fromFormat;
    private final FormatOptions formatOptions;

    private InputConversion(BuilderImpl builder) {
        this.fromFormat = builder.fromFormat;
        this.formatOptions = builder.formatOptions;
    }

    public final FromFormat fromFormat() {
        return FromFormat.fromValue(this.fromFormat);
    }

    public final String fromFormatAsString() {
        return this.fromFormat;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConversion)) {
            return false;
        }
        InputConversion other = (InputConversion)obj;
        return Objects.equals(this.fromFormatAsString(), other.fromFormatAsString()) && Objects.equals(this.formatOptions(), other.formatOptions());
    }

    public final String toString() {
        return ToString.builder((String)"InputConversion").add("FromFormat", (Object)this.fromFormatAsString()).add("FormatOptions", (Object)this.formatOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromFormat": {
                return Optional.ofNullable(clazz.cast(this.fromFormatAsString()));
            }
            case "formatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputConversion, T> g) {
        return obj -> g.apply((InputConversion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fromFormat;
        private FormatOptions formatOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConversion model) {
            this.fromFormat(model.fromFormat);
            this.formatOptions(model.formatOptions);
        }

        public final String getFromFormat() {
            return this.fromFormat;
        }

        public final void setFromFormat(String fromFormat) {
            this.fromFormat = fromFormat;
        }

        @Override
        public final Builder fromFormat(String fromFormat) {
            this.fromFormat = fromFormat;
            return this;
        }

        @Override
        public final Builder fromFormat(FromFormat fromFormat) {
            this.fromFormat(fromFormat == null ? null : fromFormat.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public InputConversion build() {
            return new InputConversion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputConversion> {
        public Builder fromFormat(String var1);

        public Builder fromFormat(FromFormat var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }
    }
}

