/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.ConversionSourceFormat;
import software.amazon.awssdk.services.b2bi.model.InputFileSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversionSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversionSource> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(ConversionSource.getter(ConversionSource::fileFormatAsString)).setter(ConversionSource.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<InputFileSource> INPUT_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputFile").getter(ConversionSource.getter(ConversionSource::inputFile)).setter(ConversionSource.setter(Builder::inputFile)).constructor(InputFileSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD, INPUT_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fileFormat", FILE_FORMAT_FIELD);
            this.put("inputFile", INPUT_FILE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fileFormat;
    private final InputFileSource inputFile;

    private ConversionSource(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.inputFile = builder.inputFile;
    }

    public final ConversionSourceFormat fileFormat() {
        return ConversionSourceFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final InputFileSource inputFile() {
        return this.inputFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionSource)) {
            return false;
        }
        ConversionSource other = (ConversionSource)obj;
        return Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.inputFile(), other.inputFile());
    }

    public final String toString() {
        return ToString.builder((String)"ConversionSource").add("FileFormat", (Object)this.fileFormatAsString()).add("InputFile", (Object)this.inputFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "inputFile": {
                return Optional.ofNullable(clazz.cast(this.inputFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConversionSource, T> g) {
        return obj -> g.apply((ConversionSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileFormat;
        private InputFileSource inputFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionSource model) {
            this.fileFormat(model.fileFormat);
            this.inputFile(model.inputFile);
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ConversionSourceFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final InputFileSource.Builder getInputFile() {
            return this.inputFile != null ? this.inputFile.toBuilder() : null;
        }

        public final void setInputFile(InputFileSource.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(InputFileSource inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public ConversionSource build() {
            return new ConversionSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversionSource> {
        public Builder fileFormat(String var1);

        public Builder fileFormat(ConversionSourceFormat var1);

        public Builder inputFile(InputFileSource var1);

        default public Builder inputFile(Consumer<InputFileSource.Builder> inputFile) {
            return this.inputFile((InputFileSource)((InputFileSource.Builder)InputFileSource.builder().applyMutation(inputFile)).build());
        }
    }
}

