/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.CapabilitySummary;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse;

public class ListCapabilitiesPublisher
implements SdkPublisher<ListCapabilitiesResponse> {
    private final B2BiAsyncClient client;
    private final ListCapabilitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapabilitiesPublisher(B2BiAsyncClient client, ListCapabilitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapabilitiesPublisher(B2BiAsyncClient client, ListCapabilitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapabilitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCapabilitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapabilitySummary> capabilities() {
        Function<ListCapabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.capabilities() != null) {
                return response.capabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCapabilitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCapabilitiesResponseFetcher
    implements AsyncPageFetcher<ListCapabilitiesResponse> {
        private ListCapabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCapabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCapabilitiesResponse> nextPage(ListCapabilitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCapabilitiesPublisher.this.client.listCapabilities(ListCapabilitiesPublisher.this.firstRequest);
            }
            return ListCapabilitiesPublisher.this.client.listCapabilities((ListCapabilitiesRequest)((Object)ListCapabilitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

