/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.ValidationMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConversionResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, TestConversionResponse> {
    private static final SdkField<String> CONVERTED_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("convertedFileContent").getter(TestConversionResponse.getter(TestConversionResponse::convertedFileContent)).setter(TestConversionResponse.setter(Builder::convertedFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convertedFileContent").build()}).build();
    private static final SdkField<List<String>> VALIDATION_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationMessages").getter(TestConversionResponse.getter(TestConversionResponse::validationMessages)).setter(TestConversionResponse.setter(Builder::validationMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERTED_FILE_CONTENT_FIELD, VALIDATION_MESSAGES_FIELD));
    private final String convertedFileContent;
    private final List<String> validationMessages;

    private TestConversionResponse(BuilderImpl builder) {
        super(builder);
        this.convertedFileContent = builder.convertedFileContent;
        this.validationMessages = builder.validationMessages;
    }

    public final String convertedFileContent() {
        return this.convertedFileContent;
    }

    public final boolean hasValidationMessages() {
        return this.validationMessages != null && !(this.validationMessages instanceof SdkAutoConstructList);
    }

    public final List<String> validationMessages() {
        return this.validationMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.convertedFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationMessages() ? this.validationMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConversionResponse)) {
            return false;
        }
        TestConversionResponse other = (TestConversionResponse)((Object)obj);
        return Objects.equals(this.convertedFileContent(), other.convertedFileContent()) && this.hasValidationMessages() == other.hasValidationMessages() && Objects.equals(this.validationMessages(), other.validationMessages());
    }

    public final String toString() {
        return ToString.builder((String)"TestConversionResponse").add("ConvertedFileContent", (Object)this.convertedFileContent()).add("ValidationMessages", this.hasValidationMessages() ? this.validationMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "convertedFileContent": {
                return Optional.ofNullable(clazz.cast(this.convertedFileContent()));
            }
            case "validationMessages": {
                return Optional.ofNullable(clazz.cast(this.validationMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestConversionResponse, T> g) {
        return obj -> g.apply((TestConversionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String convertedFileContent;
        private List<String> validationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestConversionResponse model) {
            super(model);
            this.convertedFileContent(model.convertedFileContent);
            this.validationMessages(model.validationMessages);
        }

        public final String getConvertedFileContent() {
            return this.convertedFileContent;
        }

        public final void setConvertedFileContent(String convertedFileContent) {
            this.convertedFileContent = convertedFileContent;
        }

        @Override
        public final Builder convertedFileContent(String convertedFileContent) {
            this.convertedFileContent = convertedFileContent;
            return this;
        }

        public final Collection<String> getValidationMessages() {
            if (this.validationMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validationMessages;
        }

        public final void setValidationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
        }

        @Override
        public final Builder validationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMessages(String ... validationMessages) {
            this.validationMessages(Arrays.asList(validationMessages));
            return this;
        }

        @Override
        public TestConversionResponse build() {
            return new TestConversionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestConversionResponse> {
        public Builder convertedFileContent(String var1);

        public Builder validationMessages(Collection<String> var1);

        public Builder validationMessages(String ... var1);
    }
}

