/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.b2bi.model.X12Envelope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutboundEdiOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutboundEdiOptions> {
    private static final SdkField<X12Envelope> X12_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("x12").getter(OutboundEdiOptions.getter(OutboundEdiOptions::x12)).setter(OutboundEdiOptions.setter(Builder::x12)).constructor(X12Envelope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_FIELD));
    private static final long serialVersionUID = 1L;
    private final X12Envelope x12;
    private final Type type;

    private OutboundEdiOptions(BuilderImpl builder) {
        this.x12 = builder.x12;
        this.type = builder.type;
    }

    public final X12Envelope x12() {
        return this.x12;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.x12());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundEdiOptions)) {
            return false;
        }
        OutboundEdiOptions other = (OutboundEdiOptions)obj;
        return Objects.equals(this.x12(), other.x12());
    }

    public final String toString() {
        return ToString.builder((String)"OutboundEdiOptions").add("X12", (Object)this.x12()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "x12": {
                return Optional.ofNullable(clazz.cast(this.x12()));
            }
        }
        return Optional.empty();
    }

    public static OutboundEdiOptions fromX12(X12Envelope x12) {
        return (OutboundEdiOptions)OutboundEdiOptions.builder().x12(x12).build();
    }

    public static OutboundEdiOptions fromX12(Consumer<X12Envelope.Builder> x12) {
        X12Envelope.Builder builder = X12Envelope.builder();
        x12.accept(builder);
        return OutboundEdiOptions.fromX12((X12Envelope)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutboundEdiOptions, T> g) {
        return obj -> g.apply((OutboundEdiOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        X12,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private X12Envelope x12;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundEdiOptions model) {
            this.x12(model.x12);
        }

        public final X12Envelope.Builder getX12() {
            return this.x12 != null ? this.x12.toBuilder() : null;
        }

        public final void setX12(X12Envelope.BuilderImpl x12) {
            X12Envelope oldValue = this.x12;
            this.x12 = x12 != null ? x12.build() : null;
            this.handleUnionValueChange(Type.X12, oldValue, this.x12);
        }

        @Override
        public final Builder x12(X12Envelope x12) {
            X12Envelope oldValue = this.x12;
            this.x12 = x12;
            this.handleUnionValueChange(Type.X12, oldValue, this.x12);
            return this;
        }

        public OutboundEdiOptions build() {
            return new OutboundEdiOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutboundEdiOptions> {
        public Builder x12(X12Envelope var1);

        default public Builder x12(Consumer<X12Envelope.Builder> x12) {
            return this.x12((X12Envelope)((X12Envelope.Builder)X12Envelope.builder().applyMutation(x12)).build());
        }
    }
}

