/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.services.b2bi.model.S3LocationListCopier;
import software.amazon.awssdk.services.b2bi.model.TransformerJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransformerJobResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, GetTransformerJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTransformerJobResponse.getter(GetTransformerJobResponse::statusAsString)).setter(GetTransformerJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<S3Location>> OUTPUT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputFiles").getter(GetTransformerJobResponse.getter(GetTransformerJobResponse::outputFiles)).setter(GetTransformerJobResponse.setter(Builder::outputFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(GetTransformerJobResponse.getter(GetTransformerJobResponse::message)).setter(GetTransformerJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, OUTPUT_FILES_FIELD, MESSAGE_FIELD));
    private final String status;
    private final List<S3Location> outputFiles;
    private final String message;

    private GetTransformerJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.outputFiles = builder.outputFiles;
        this.message = builder.message;
    }

    public final TransformerJobStatus status() {
        return TransformerJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasOutputFiles() {
        return this.outputFiles != null && !(this.outputFiles instanceof SdkAutoConstructList);
    }

    public final List<S3Location> outputFiles() {
        return this.outputFiles;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputFiles() ? this.outputFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerJobResponse)) {
            return false;
        }
        GetTransformerJobResponse other = (GetTransformerJobResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasOutputFiles() == other.hasOutputFiles() && Objects.equals(this.outputFiles(), other.outputFiles()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransformerJobResponse").add("Status", (Object)this.statusAsString()).add("OutputFiles", this.hasOutputFiles() ? this.outputFiles() : null).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "outputFiles": {
                return Optional.ofNullable(clazz.cast(this.outputFiles()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerJobResponse, T> g) {
        return obj -> g.apply((GetTransformerJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String status;
        private List<S3Location> outputFiles = DefaultSdkAutoConstructList.getInstance();
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerJobResponse model) {
            super(model);
            this.status(model.status);
            this.outputFiles(model.outputFiles);
            this.message(model.message);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<S3Location.Builder> getOutputFiles() {
            List<S3Location.Builder> result = S3LocationListCopier.copyToBuilder(this.outputFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputFiles(Collection<S3Location.BuilderImpl> outputFiles) {
            this.outputFiles = S3LocationListCopier.copyFromBuilder(outputFiles);
        }

        @Override
        public final Builder outputFiles(Collection<S3Location> outputFiles) {
            this.outputFiles = S3LocationListCopier.copy(outputFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFiles(S3Location ... outputFiles) {
            this.outputFiles(Arrays.asList(outputFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputFiles(Consumer<S3Location.Builder> ... outputFiles) {
            this.outputFiles(Stream.of(outputFiles).map(c -> (S3Location)((S3Location.Builder)S3Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public GetTransformerJobResponse build() {
            return new GetTransformerJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransformerJobResponse> {
        public Builder status(String var1);

        public Builder status(TransformerJobStatus var1);

        public Builder outputFiles(Collection<S3Location> var1);

        public Builder outputFiles(S3Location ... var1);

        public Builder outputFiles(Consumer<S3Location.Builder> ... var1);

        public Builder message(String var1);
    }
}

