/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestAdapter;
import software.amazon.awssdk.http.crt.internal.response.InputStreamAdaptingHttpStreamResponseHandler;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;

@SdkInternalApi
public final class CrtRequestExecutor {
    public CompletableFuture<SdkHttpFullResponse> execute(CrtRequestContext executionContext) {
        MetricCollector metricCollector = executionContext.metricCollector();
        boolean shouldPublishMetrics = metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
        long acquireStartTime = 0L;
        if (shouldPublishMetrics) {
            acquireStartTime = System.nanoTime();
        }
        CompletableFuture<SdkHttpFullResponse> requestFuture = new CompletableFuture<SdkHttpFullResponse>();
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        long finalAcquireStartTime = acquireStartTime;
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            if (shouldPublishMetrics) {
                CrtUtils.reportMetrics(executionContext.crtConnPool(), metricCollector, finalAcquireStartTime);
            }
            if (throwable != null) {
                Throwable toThrow = CrtUtils.wrapConnectionFailureException(throwable);
                requestFuture.completeExceptionally(toThrow);
                return;
            }
            this.executeRequest(executionContext, requestFuture, (HttpClientConnection)crtConn);
        });
        return requestFuture;
    }

    private void executeRequest(CrtRequestContext executionContext, CompletableFuture<SdkHttpFullResponse> requestFuture, HttpClientConnection crtConn) {
        HttpRequest crtRequest = CrtRequestAdapter.toCrtRequest(executionContext);
        try {
            InputStreamAdaptingHttpStreamResponseHandler crtResponseHandler = new InputStreamAdaptingHttpStreamResponseHandler(crtConn, requestFuture);
            crtConn.makeRequest(crtRequest, (HttpStreamResponseHandler)crtResponseHandler).activate();
        }
        catch (Throwable throwable) {
            CrtRequestExecutor.handleException(requestFuture, crtConn, throwable);
        }
    }

    private static void handleException(CompletableFuture<SdkHttpFullResponse> requestFuture, HttpClientConnection crtConn, Throwable throwable) {
        crtConn.close();
        if (throwable instanceof HttpException) {
            Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable((HttpException)throwable);
            requestFuture.completeExceptionally(toThrow);
            return;
        }
        if (throwable instanceof CrtRuntimeException || throwable instanceof IllegalStateException) {
            requestFuture.completeExceptionally(new IOException(throwable));
            return;
        }
        requestFuture.completeExceptionally(throwable);
    }
}

