/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.request;

import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.async.ByteBufferStoringSubscriber;

@SdkInternalApi
final class CrtRequestBodyAdapter
implements HttpRequestBodyStream {
    private final SdkHttpContentPublisher requestPublisher;
    private final ByteBufferStoringSubscriber requestBodySubscriber;

    CrtRequestBodyAdapter(SdkHttpContentPublisher requestPublisher, long readLimit) {
        this.requestPublisher = requestPublisher;
        this.requestBodySubscriber = new ByteBufferStoringSubscriber(readLimit);
        requestPublisher.subscribe((Subscriber)this.requestBodySubscriber);
    }

    public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
        return this.requestBodySubscriber.transferTo(bodyBytesOut) == ByteBufferStoringSubscriber.TransferResult.END_OF_STREAM;
    }

    public long getLength() {
        return this.requestPublisher.contentLength().orElse(0L);
    }
}

