/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.net.URI;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.crtcore.CrtConfigurationUtils;
import software.amazon.awssdk.crtcore.CrtConnectionHealthConfiguration;
import software.amazon.awssdk.crtcore.CrtProxyConfiguration;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.crt.ConnectionHealthConfiguration;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.crt.TcpKeepAliveConfiguration;
import software.amazon.awssdk.http.crt.internal.AwsCrtConfigurationUtils;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.CrtRequestExecutor;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class AwsCrtAsyncHttpClient
implements SdkAsyncHttpClient {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(AwsCrtAsyncHttpClient.class);
    private static final String AWS_COMMON_RUNTIME = "AwsCommonRuntime";
    private static final long DEFAULT_STREAM_WINDOW_SIZE = 0x1000000L;
    private final Map<URI, HttpClientConnectionManager> connectionPools = new ConcurrentHashMap<URI, HttpClientConnectionManager>();
    private final LinkedList<CrtResource> ownedSubResources = new LinkedList();
    private final ClientBootstrap bootstrap;
    private final SocketOptions socketOptions;
    private final TlsContext tlsContext;
    private final HttpProxyOptions proxyOptions;
    private final HttpMonitoringOptions monitoringOptions;
    private final long maxConnectionIdleInMilliseconds;
    private final long readBufferSize;
    private final int maxConnectionsPerEndpoint;
    private boolean isClosed = false;

    private AwsCrtAsyncHttpClient(DefaultBuilder builder, AttributeMap config) {
        if (config.get((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL) == Protocol.HTTP2) {
            throw new UnsupportedOperationException("HTTP/2 is not supported in AwsCrtAsyncHttpClient yet. Use NettyNioAsyncHttpClient instead.");
        }
        try (ClientBootstrap clientBootstrap = new ClientBootstrap(null, null);
             SocketOptions clientSocketOptions = AwsCrtConfigurationUtils.buildSocketOptions(builder.tcpKeepAliveConfiguration, (Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT));
             TlsContextOptions clientTlsContextOptions = TlsContextOptions.createDefaultClient().withCipherPreference(AwsCrtConfigurationUtils.resolveCipherPreference(builder.postQuantumTlsEnabled)).withVerifyPeer((Boolean)config.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false);
             TlsContext clientTlsContext = new TlsContext(clientTlsContextOptions);){
            this.bootstrap = this.registerOwnedResource(clientBootstrap);
            this.socketOptions = this.registerOwnedResource(clientSocketOptions);
            this.tlsContext = this.registerOwnedResource(clientTlsContext);
            this.readBufferSize = builder.readBufferSize == null ? 0x1000000L : builder.readBufferSize;
            this.maxConnectionsPerEndpoint = (Integer)config.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
            this.monitoringOptions = CrtConfigurationUtils.resolveHttpMonitoringOptions((CrtConnectionHealthConfiguration)builder.connectionHealthConfiguration).orElse(null);
            this.maxConnectionIdleInMilliseconds = ((Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)).toMillis();
            this.proxyOptions = CrtConfigurationUtils.resolveProxy((CrtProxyConfiguration)builder.proxyConfiguration, (TlsContext)this.tlsContext).orElse(null);
        }
    }

    private <T extends CrtResource> T registerOwnedResource(T subresource) {
        if (subresource != null) {
            subresource.addRef();
            this.ownedSubResources.push(subresource);
        }
        return subresource;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkAsyncHttpClient create() {
        return new DefaultBuilder().build();
    }

    public String clientName() {
        return AWS_COMMON_RUNTIME;
    }

    private HttpClientConnectionManager createConnectionPool(URI uri) {
        log.debug(() -> "Creating ConnectionPool for: URI:" + uri + ", MaxConns: " + this.maxConnectionsPerEndpoint);
        HttpClientConnectionManagerOptions options = new HttpClientConnectionManagerOptions().withClientBootstrap(this.bootstrap).withSocketOptions(this.socketOptions).withTlsContext(this.tlsContext).withUri(uri).withWindowSize(this.readBufferSize).withMaxConnections(this.maxConnectionsPerEndpoint).withManualWindowManagement(true).withProxyOptions(this.proxyOptions).withMonitoringOptions(this.monitoringOptions).withMaxConnectionIdleInMilliseconds(this.maxConnectionIdleInMilliseconds);
        return HttpClientConnectionManager.create((HttpClientConnectionManagerOptions)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientConnectionManager getOrCreateConnectionPool(URI uri) {
        AwsCrtAsyncHttpClient awsCrtAsyncHttpClient = this;
        synchronized (awsCrtAsyncHttpClient) {
            if (this.isClosed) {
                throw new IllegalStateException("Client is closed. No more requests can be made with this client.");
            }
            HttpClientConnectionManager connPool = this.connectionPools.computeIfAbsent(uri, this::createConnectionPool);
            connPool.addRef();
            return connPool;
        }
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest asyncRequest) {
        MetricCollector metricCollector;
        Validate.paramNotNull((Object)asyncRequest, (String)"asyncRequest");
        Validate.paramNotNull((Object)asyncRequest.request(), (String)"SdkHttpRequest");
        Validate.paramNotNull((Object)asyncRequest.requestContentPublisher(), (String)"RequestContentPublisher");
        Validate.paramNotNull((Object)asyncRequest.responseHandler(), (String)"ResponseHandler");
        if (asyncRequest.metricCollector().isPresent() && (metricCollector = (MetricCollector)asyncRequest.metricCollector().get()) != null && !(metricCollector instanceof NoOpMetricCollector)) {
            metricCollector.reportMetric(HttpMetric.HTTP_CLIENT_NAME, (Object)this.clientName());
        }
        try (HttpClientConnectionManager crtConnPool = this.getOrCreateConnectionPool(this.poolKey(asyncRequest));){
            CrtRequestContext context = CrtRequestContext.builder().crtConnPool(crtConnPool).readBufferSize(this.readBufferSize).request(asyncRequest).build();
            CompletableFuture<Void> completableFuture = new CrtRequestExecutor().execute(context);
            return completableFuture;
        }
    }

    private URI poolKey(AsyncExecuteRequest asyncRequest) {
        SdkHttpRequest sdkRequest = asyncRequest.request();
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AwsCrtAsyncHttpClient awsCrtAsyncHttpClient = this;
        synchronized (awsCrtAsyncHttpClient) {
            if (this.isClosed) {
                return;
            }
            this.connectionPools.values().forEach(pool -> IoUtils.closeQuietly((AutoCloseable)pool, (Logger)log.logger()));
            this.ownedSubResources.forEach(r -> IoUtils.closeQuietly((AutoCloseable)r, (Logger)log.logger()));
            this.ownedSubResources.clear();
            this.isClosed = true;
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private Long readBufferSize;
        private ProxyConfiguration proxyConfiguration;
        private ConnectionHealthConfiguration connectionHealthConfiguration;
        private TcpKeepAliveConfiguration tcpKeepAliveConfiguration;
        private Boolean postQuantumTlsEnabled;

        private DefaultBuilder() {
        }

        public SdkAsyncHttpClient build() {
            return new AwsCrtAsyncHttpClient(this, this.standardOptions.build().merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new AwsCrtAsyncHttpClient(this, this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }

        @Override
        public Builder maxConcurrency(Integer maxConcurrency) {
            Validate.isPositiveOrNull((Integer)maxConcurrency, (String)"maxConcurrency");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConcurrency);
            return this;
        }

        @Override
        public Builder readBufferSizeInBytes(Long readBufferSize) {
            Validate.isPositiveOrNull((Long)readBufferSize, (String)"readBufferSize");
            this.readBufferSize = readBufferSize;
            return this;
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        @Override
        public Builder connectionHealthConfiguration(ConnectionHealthConfiguration monitoringOptions) {
            this.connectionHealthConfiguration = monitoringOptions;
            return this;
        }

        @Override
        public Builder connectionHealthConfiguration(Consumer<ConnectionHealthConfiguration.Builder> configurationBuilder) {
            ConnectionHealthConfiguration.Builder builder = ConnectionHealthConfiguration.builder();
            configurationBuilder.accept(builder);
            return this.connectionHealthConfiguration(builder.build());
        }

        @Override
        public Builder connectionMaxIdleTime(Duration connectionMaxIdleTime) {
            Validate.isPositive((Duration)connectionMaxIdleTime, (String)"connectionMaxIdleTime");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)connectionMaxIdleTime);
            return this;
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            Validate.isPositive((Duration)connectionTimeout, (String)"connectionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        @Override
        public Builder tcpKeepAliveConfiguration(TcpKeepAliveConfiguration tcpKeepAliveConfiguration) {
            this.tcpKeepAliveConfiguration = tcpKeepAliveConfiguration;
            return this;
        }

        @Override
        public Builder tcpKeepAliveConfiguration(Consumer<TcpKeepAliveConfiguration.Builder> tcpKeepAliveConfigurationBuilder) {
            TcpKeepAliveConfiguration.Builder builder = TcpKeepAliveConfiguration.builder();
            tcpKeepAliveConfigurationBuilder.accept(builder);
            return this.tcpKeepAliveConfiguration(builder.build());
        }

        @Override
        public Builder postQuantumTlsEnabled(Boolean postQuantumTlsEnabled) {
            this.postQuantumTlsEnabled = postQuantumTlsEnabled;
            return this;
        }

        @Override
        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfigurationBuilderConsumer) {
            ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
            proxyConfigurationBuilderConsumer.accept(builder);
            return this.proxyConfiguration(builder.build());
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConcurrency(Integer var1);

        public Builder readBufferSizeInBytes(Long var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder proxyConfiguration(Consumer<ProxyConfiguration.Builder> var1);

        public Builder connectionHealthConfiguration(ConnectionHealthConfiguration var1);

        public Builder connectionHealthConfiguration(Consumer<ConnectionHealthConfiguration.Builder> var1);

        public Builder connectionMaxIdleTime(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder tcpKeepAliveConfiguration(TcpKeepAliveConfiguration var1);

        public Builder tcpKeepAliveConfiguration(Consumer<TcpKeepAliveConfiguration.Builder> var1);

        public Builder postQuantumTlsEnabled(Boolean var1);
    }
}

