/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpManagerMetrics;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestAdapter;
import software.amazon.awssdk.http.crt.internal.response.CrtResponseAdapter;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class CrtRequestExecutor {
    private static final Logger log = Logger.loggerFor(CrtRequestExecutor.class);

    public CompletableFuture<Void> execute(CrtRequestContext executionContext) {
        MetricCollector metricCollector = executionContext.metricCollector();
        boolean shouldPublishMetrics = metricCollector != null && !(metricCollector instanceof NoOpMetricCollector);
        long acquireStartTime = 0L;
        if (shouldPublishMetrics) {
            acquireStartTime = System.nanoTime();
        }
        CompletableFuture<Void> requestFuture = this.createExecutionFuture(executionContext.sdkRequest());
        CompletableFuture httpClientConnectionCompletableFuture = executionContext.crtConnPool().acquireConnection();
        long finalAcquireStartTime = acquireStartTime;
        httpClientConnectionCompletableFuture.whenComplete((crtConn, throwable) -> {
            AsyncExecuteRequest asyncRequest = executionContext.sdkRequest();
            if (shouldPublishMetrics) {
                CrtRequestExecutor.reportMetrics(executionContext, metricCollector, finalAcquireStartTime);
            }
            if (throwable != null) {
                this.reportFailure((HttpClientConnection)crtConn, new IOException("An exception occurred when acquiring a connection", (Throwable)throwable), requestFuture, asyncRequest.responseHandler());
                return;
            }
            this.executeRequest(executionContext, requestFuture, (HttpClientConnection)crtConn, asyncRequest);
        });
        return requestFuture;
    }

    private static void reportMetrics(CrtRequestContext executionContext, MetricCollector metricCollector, long acquireStartTime) {
        long acquireCompletionTime = System.nanoTime();
        Duration acquireTimeTaken = Duration.ofNanos(acquireCompletionTime - acquireStartTime);
        metricCollector.reportMetric(HttpMetric.CONCURRENCY_ACQUIRE_DURATION, (Object)acquireTimeTaken);
        HttpClientConnectionManager connManager = executionContext.crtConnPool();
        HttpManagerMetrics managerMetrics = connManager.getManagerMetrics();
        metricCollector.reportMetric(HttpMetric.MAX_CONCURRENCY, (Object)connManager.getMaxConnections());
        metricCollector.reportMetric(HttpMetric.AVAILABLE_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getAvailableConcurrency()));
        metricCollector.reportMetric(HttpMetric.LEASED_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getLeasedConcurrency()));
        metricCollector.reportMetric(HttpMetric.PENDING_CONCURRENCY_ACQUIRES, (Object)NumericUtils.saturatedCast((long)managerMetrics.getPendingConcurrencyAcquires()));
    }

    private void executeRequest(CrtRequestContext executionContext, CompletableFuture<Void> requestFuture, HttpClientConnection crtConn, AsyncExecuteRequest asyncRequest) {
        HttpRequest crtRequest = CrtRequestAdapter.toCrtRequest(executionContext);
        HttpStreamResponseHandler crtResponseHandler = CrtResponseAdapter.toCrtResponseHandler(crtConn, requestFuture, asyncRequest.responseHandler());
        try {
            crtConn.makeRequest(crtRequest, crtResponseHandler).activate();
        }
        catch (HttpException e) {
            Throwable toThrow = e;
            if (HttpClientConnection.isErrorRetryable((HttpException)e)) {
                toThrow = new IOException(e);
            }
            this.reportFailure(crtConn, toThrow, requestFuture, asyncRequest.responseHandler());
        }
        catch (IllegalStateException | CrtRuntimeException e) {
            this.reportFailure(crtConn, new IOException("An exception occurred when making the request", e), requestFuture, asyncRequest.responseHandler());
        }
    }

    private CompletableFuture<Void> createExecutionFuture(AsyncExecuteRequest request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, t) -> {
            if (t == null) {
                return;
            }
            if (future.isCancelled()) {
                request.responseHandler().onError((Throwable)new SdkCancellationException("The request was cancelled"));
            }
        });
        return future;
    }

    private void reportFailure(HttpClientConnection crtConn, Throwable cause, CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        if (crtConn != null) {
            crtConn.close();
        }
        try {
            responseHandler.onError(cause);
        }
        catch (Exception e) {
            log.error(() -> "SdkAsyncHttpResponseHandler " + responseHandler + " threw an exception in onError. It will be ignored.", (Throwable)e);
        }
        executeFuture.completeExceptionally(cause);
    }
}

