/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class ConnectionHealthConfiguration {
    private final long minimumThroughputInBps;
    private final Duration minimumThroughputTimeout;

    private ConnectionHealthConfiguration(DefaultConnectionHealthConfigurationBuilder builder) {
        this.minimumThroughputInBps = (Long)Validate.paramNotNull((Object)builder.minimumThroughputInBps, (String)"minimumThroughputInBps");
        this.minimumThroughputTimeout = Validate.isPositive((Duration)builder.minimumThroughputTimeout, (String)"minimumThroughputTimeout");
    }

    public long minimumThroughputInBps() {
        return this.minimumThroughputInBps;
    }

    public Duration minimumThroughputTimeout() {
        return this.minimumThroughputTimeout;
    }

    public static Builder builder() {
        return new DefaultConnectionHealthConfigurationBuilder();
    }

    private static final class DefaultConnectionHealthConfigurationBuilder
    implements Builder {
        private Long minimumThroughputInBps;
        private Duration minimumThroughputTimeout;

        private DefaultConnectionHealthConfigurationBuilder() {
        }

        @Override
        public Builder minimumThroughputInBps(Long minimumThroughputInBps) {
            this.minimumThroughputInBps = minimumThroughputInBps;
            return this;
        }

        @Override
        public Builder minimumThroughputTimeout(Duration minimumThroughputTimeout) {
            this.minimumThroughputTimeout = minimumThroughputTimeout;
            return this;
        }

        @Override
        public ConnectionHealthConfiguration build() {
            return new ConnectionHealthConfiguration(this);
        }
    }

    public static interface Builder {
        public Builder minimumThroughputInBps(Long var1);

        public Builder minimumThroughputTimeout(Duration var1);

        public ConnectionHealthConfiguration build();
    }
}

