/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.interceptor;

import java.net.UnknownHostException;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;

@SdkProtectedApi
public final class GlobalServiceExecutionInterceptor
implements ExecutionInterceptor {
    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        if (this.hasCause(context.exception(), UnknownHostException.class) && !((Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION)).isGlobalRegion()) {
            throw SdkClientException.builder().message("This is a global service. Consider setting AWS_GLOBAL or another global region when creating your client.").cause(context.exception()).build();
        }
    }

    private boolean hasCause(Throwable thrown, Class<? extends Throwable> cause) {
        if (thrown == null) {
            return false;
        }
        if (cause.isAssignableFrom(thrown.getClass())) {
            return true;
        }
        return this.hasCause(thrown.getCause(), cause);
    }
}

