/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.exception;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.internal.AwsErrorCode;
import software.amazon.awssdk.core.exception.SdkServiceException;

@SdkPublicApi
public class AwsServiceException
extends SdkServiceException {
    private AwsErrorDetails awsErrorDetails;

    protected AwsServiceException(Builder b) {
        super((SdkServiceException.Builder)b);
        this.awsErrorDetails = b.awsErrorDetails();
    }

    public AwsErrorDetails awsErrorDetails() {
        return this.awsErrorDetails;
    }

    public String getMessage() {
        if (this.awsErrorDetails != null) {
            return this.awsErrorDetails().errorMessage() + " (Service: " + this.awsErrorDetails().serviceName() + ", Status Code: " + this.statusCode() + ", Request ID: " + this.requestId() + ")";
        }
        return super.getMessage();
    }

    public boolean isClockSkewException() {
        return Optional.ofNullable(this.awsErrorDetails).map(a -> AwsErrorCode.CLOCK_SKEW_ERROR_CODES.contains(a.errorCode())).orElse(false);
    }

    public boolean isThrottlingException() {
        return super.isThrottlingException() || Optional.ofNullable(this.awsErrorDetails).map(a -> AwsErrorCode.THROTTLING_ERROR_CODES.contains(a.errorCode())).orElse(false) != false;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    protected static class BuilderImpl
    extends SdkServiceException.BuilderImpl
    implements Builder {
        protected AwsErrorDetails awsErrorDetails;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AwsServiceException ex) {
            super((SdkServiceException)ex);
            this.awsErrorDetails = ex.awsErrorDetails();
        }

        @Override
        public Builder awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public AwsErrorDetails awsErrorDetails() {
            return this.awsErrorDetails;
        }

        public AwsErrorDetails getAwsErrorDetails() {
            return this.awsErrorDetails;
        }

        public void setAwsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public AwsServiceException build() {
            return new AwsServiceException(this);
        }
    }

    public static interface Builder
    extends SdkServiceException.Builder {
        public Builder awsErrorDetails(AwsErrorDetails var1);

        public AwsErrorDetails awsErrorDetails();

        public Builder message(String var1);

        public Builder cause(Throwable var1);

        public Builder requestId(String var1);

        public Builder statusCode(int var1);

        public AwsServiceException build();
    }
}

