/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.protocol.json;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.internal.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.internal.protocol.json.JsonContent;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;

@ReviewBeforeRelease(value="Clean up ION parser")
@SdkInternalApi
public class IonErrorCodeParser
implements ErrorCodeParser {
    private static final Logger log = LoggerFactory.getLogger(IonErrorCodeParser.class);
    private static final String TYPE_PREFIX = "aws-type:";
    private static final String X_AMZN_REQUEST_ID_HEADER = "x-amzn-RequestId";
    private final IonSystem ionSystem;

    public IonErrorCodeParser(IonSystem ionSystem) {
        this.ionSystem = ionSystem;
    }

    private static String getRequestId(HttpResponse response) {
        return (String)response.getHeaders().get(X_AMZN_REQUEST_ID_HEADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContents) {
        IonReader reader = this.ionSystem.newReader(jsonContents.getRawContent());
        try {
            String[] annotations;
            IonType type = reader.next();
            if (type != IonType.STRUCT) {
                throw SdkClientException.builder().message(String.format("Can only get error codes from structs (saw %s), request id %s", type, IonErrorCodeParser.getRequestId(response))).build();
            }
            boolean errorCodeSeen = false;
            String errorCode = null;
            for (String annotation : annotations = reader.getTypeAnnotations()) {
                if (!annotation.startsWith(TYPE_PREFIX)) continue;
                if (errorCodeSeen) {
                    throw SdkClientException.builder().message(String.format("Multiple error code annotations found for request id %s", IonErrorCodeParser.getRequestId(response))).build();
                }
                errorCodeSeen = true;
                errorCode = annotation.substring(TYPE_PREFIX.length());
            }
            String[] stringArray = errorCode;
            return stringArray;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)reader, (Logger)log);
        }
    }
}

