/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.protocol.json;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.http.response.AwsJsonErrorResponseHandler;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonErrorUnmarshaller;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsStructuredJsonFactory;
import software.amazon.awssdk.awscore.internal.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.awscore.internal.protocol.json.JsonErrorCodeParser;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonErrorMessageParser;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

@SdkInternalApi
public abstract class BaseAwsStructuredJsonFactory
implements AwsStructuredJsonFactory {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers;

    BaseAwsStructuredJsonFactory(JsonFactory jsonFactory, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers) {
        this.jsonFactory = jsonFactory;
        this.unmarshallers = unmarshallers;
    }

    public StructuredJsonGenerator createWriter(String contentType) {
        return this.createWriter(this.jsonFactory, contentType);
    }

    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return new JsonResponseHandler(responseUnmarshaller, this.unmarshallers, this.jsonFactory, operationMetadata.isHasStreamingSuccessResponse(), operationMetadata.isPayloadJson());
    }

    @Override
    public AwsJsonErrorResponseHandler createErrorResponseHandler(List<AwsJsonErrorUnmarshaller> errorUnmarshallers, String customErrorCodeFieldName) {
        return new AwsJsonErrorResponseHandler(errorUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), AwsJsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    protected abstract StructuredJsonGenerator createWriter(JsonFactory var1, String var2);

    protected ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new JsonErrorCodeParser(customErrorCodeFieldName);
    }
}

