/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.xml;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.core.util.xml.XpathUtils;

@SdkProtectedApi
public final class LegacyErrorUnmarshaller
extends AbstractErrorUnmarshaller<AwsServiceException, Node> {
    public LegacyErrorUnmarshaller() {
        this(AwsServiceException.class);
    }

    public LegacyErrorUnmarshaller(Class<? extends AwsServiceException> exceptionClass) {
        super(exceptionClass);
    }

    public AwsServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in, xpath);
        String message = XpathUtils.asString((String)"Response/Errors/Error/Message", (Node)in, (XPath)xpath);
        String requestId = XpathUtils.asString((String)"Response/RequestID", (Node)in, (XPath)xpath);
        AwsServiceException.Builder exception = ((AwsServiceException)this.newException(message)).toBuilder();
        exception.requestId(requestId);
        AwsErrorDetails awsErrorDetails = AwsErrorDetails.builder().errorCode(errorCode).build();
        exception.requestId(requestId).awsErrorDetails(awsErrorDetails);
        return exception.build();
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString((String)"Response/Errors/Error/Code", (Node)in);
    }

    public String parseErrorCode(Node in, XPath xpath) throws Exception {
        return XpathUtils.asString((String)"Response/Errors/Error/Code", (Node)in, (XPath)xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "Response/Errors/Error/" + property;
    }
}

