/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.internal.client.handler;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.internal.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.internal.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.internal.interceptor.InterceptorContext;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    public static ExecutionContext createExecutionContext(SdkRequest originalRequest, SdkClientConfiguration clientConfig) {
        AwsCredentialsProvider clientCredentials = (AwsCredentialsProvider)clientConfig.option(AwsClientOption.CREDENTIALS_PROVIDER);
        AwsCredentialsProvider credentialsProvider = originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)((Object)c)).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(clientCredentials);
        AwsCredentials credentials = credentialsProvider.resolveCredentials();
        Validate.validState((credentials != null ? 1 : 0) != 0, (String)"Credential providers must never return null.", (Object[])new Object[0]);
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG, clientConfig.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, (Object)credentials).putAttribute(AwsSignerExecutionAttribute.REQUEST_CONFIG, (Object)originalRequest.overrideConfiguration().map(c -> c).orElse(AwsRequestOverrideConfiguration.builder().build())).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, clientConfig.option(AwsClientOption.SERVICE_SIGNING_NAME)).putAttribute(AwsExecutionAttribute.AWS_REGION, clientConfig.option(AwsClientOption.AWS_REGION)).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, clientConfig.option(AwsClientOption.SIGNING_REGION));
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain((List)clientConfig.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS));
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(InterceptorContext.builder().request(originalRequest).build()).executionAttributes(executionAttributes).signer(AwsClientHandlerUtils.computeSigner(originalRequest, clientConfig)).build();
    }

    private static Signer computeSigner(SdkRequest originalRequest, SdkClientConfiguration clientConfiguration) {
        return (Signer)originalRequest.overrideConfiguration().flatMap(config -> config.signer()).orElse(clientConfiguration.option((ClientOption)AwsAdvancedClientOption.SIGNER));
    }
}

