/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.retry;

import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;

@SdkPublicApi
public class RetryOnErrorCodeCondition
implements RetryCondition {
    private final Set<String> retryableErrorCodes;

    public RetryOnErrorCodeCondition(Set<String> retryableErrorCodes) {
        this.retryableErrorCodes = retryableErrorCodes;
    }

    public boolean shouldRetry(RetryPolicyContext context) {
        SdkException ex = context.exception();
        if (ex instanceof SdkServiceException) {
            SdkServiceException exception = (SdkServiceException)ex;
            return this.retryableErrorCodes.contains(exception.errorCode());
        }
        return false;
    }
}

