/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.json;

import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.ErrorCodeParser;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.protocol.json.JsonContent;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

