/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.protocol.json;

import com.fasterxml.jackson.databind.JsonNode;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.http.HttpResponse;
import software.amazon.awssdk.core.protocol.json.ErrorMessageParser;
import software.amazon.awssdk.core.protocol.json.SdkJsonErrorMessageParser;

@SdkProtectedApi
public class AwsJsonErrorMessageParser
implements ErrorMessageParser {
    static final ErrorMessageParser DEFAULT_ERROR_MESSAGE_PARSER = new AwsJsonErrorMessageParser(SdkJsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER);
    private static final String X_AMZN_ERROR_MESSAGE = "x-amzn-error-message";
    private SdkJsonErrorMessageParser errorMessageParser;

    public AwsJsonErrorMessageParser(SdkJsonErrorMessageParser errorMessageJsonLocations) {
        this.errorMessageParser = errorMessageJsonLocations;
    }

    public String parseErrorMessage(HttpResponse httpResponse, JsonNode jsonNode) {
        String headerMessage = httpResponse.getHeader(X_AMZN_ERROR_MESSAGE);
        if (headerMessage != null) {
            return headerMessage;
        }
        return this.errorMessageParser.parseErrorMessage(httpResponse, jsonNode);
    }
}

