/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandlerImpl;
import software.amazon.awssdk.awscore.config.AwsSyncClientConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.ServiceAdvancedConfiguration;
import software.amazon.awssdk.core.client.BaseClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SyncClientHandler;
import software.amazon.awssdk.core.config.SdkClientConfiguration;
import software.amazon.awssdk.core.sync.ResponseTransformer;

@ThreadSafe
@Immutable
public class AwsSyncClientHandler
extends BaseClientHandler
implements SyncClientHandler {
    private final SyncClientHandler delegateHandler;

    public AwsSyncClientHandler(AwsSyncClientConfiguration clientConfiguration, ServiceAdvancedConfiguration serviceAdvancedConfiguration) {
        super((SdkClientConfiguration)clientConfiguration, serviceAdvancedConfiguration);
        this.delegateHandler = new AwsSyncClientHandlerImpl(clientConfiguration, serviceAdvancedConfiguration);
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse> OutputT execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return (OutputT)this.delegateHandler.execute(AwsSyncClientHandler.addErrorResponseHandler(executionParams));
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> ReturnT execute(ClientExecutionParams<InputT, OutputT> executionParams, ResponseTransformer<OutputT, ReturnT> responseTransformer) {
        return (ReturnT)this.delegateHandler.execute(AwsSyncClientHandler.addErrorResponseHandler(executionParams), responseTransformer);
    }

    public void close() {
        this.delegateHandler.close();
    }
}

