/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.AwsExecutionAttributes;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.awscore.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.config.AwsClientConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.ServiceAdvancedConfiguration;
import software.amazon.awssdk.core.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    static ExecutionContext createExecutionContext(SdkRequest originalRequest, AwsClientConfiguration clientConfiguration, ServiceAdvancedConfiguration serviceAdvancedConfiguration) {
        AwsCredentialsProvider credentialsProvider = originalRequest.requestOverrideConfig().filter(c -> c instanceof AwsRequestOverrideConfig).map(c -> (AwsRequestOverrideConfig)((Object)c)).flatMap(AwsRequestOverrideConfig::credentialsProvider).orElse(clientConfiguration.credentialsProvider());
        ClientOverrideConfiguration overrideConfiguration = clientConfiguration.overrideConfiguration();
        AwsCredentials credentials = credentialsProvider.getCredentials();
        Validate.validState((credentials != null ? 1 : 0) != 0, (String)"Credential providers must never return null.", (Object[])new Object[0]);
        ExecutionAttributes executionAttributes = new ExecutionAttributes().putAttribute(AwsExecutionAttributes.SERVICE_ADVANCED_CONFIG, (Object)serviceAdvancedConfiguration).putAttribute(AwsExecutionAttributes.AWS_CREDENTIALS, (Object)credentials).putAttribute(AwsExecutionAttributes.REQUEST_CONFIG, (Object)originalRequest.requestOverrideConfig().map(c -> c).orElse(AwsRequestOverrideConfig.builder().build())).putAttribute(AwsExecutionAttributes.AWS_REGION, overrideConfiguration.advancedOption(AwsAdvancedClientOption.AWS_REGION));
        return ExecutionContext.builder().interceptorChain(new ExecutionInterceptorChain(overrideConfiguration.executionInterceptors())).interceptorContext(InterceptorContext.builder().request(originalRequest).build()).executionAttributes(executionAttributes).signerProvider((SignerProvider)overrideConfiguration.advancedOption(AwsAdvancedClientOption.SIGNER_PROVIDER)).build();
    }
}

