/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandlerImpl;
import software.amazon.awssdk.awscore.config.AwsAsyncClientConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.ServiceAdvancedConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.BaseClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.config.SdkClientConfiguration;

@ThreadSafe
@Immutable
public final class AwsAsyncClientHandler
extends BaseClientHandler
implements AsyncClientHandler {
    private final AsyncClientHandler delegateHandler;

    public AwsAsyncClientHandler(AwsAsyncClientConfiguration clientConfiguration, ServiceAdvancedConfiguration advancedClientOption) {
        super((SdkClientConfiguration)clientConfiguration, advancedClientOption);
        this.delegateHandler = new AwsAsyncClientHandlerImpl(clientConfiguration, advancedClientOption);
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return this.delegateHandler.execute(AwsAsyncClientHandler.addErrorResponseHandler(executionParams));
    }

    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> CompletableFuture<ReturnT> execute(ClientExecutionParams<InputT, OutputT> executionParams, AsyncResponseTransformer<OutputT, ReturnT> asyncResponseTransformer) {
        return this.delegateHandler.execute(AwsAsyncClientHandler.addErrorResponseHandler(executionParams), asyncResponseTransformer);
    }

    public void close() {
        this.delegateHandler.close();
    }
}

