/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.TagFilter;
import software.amazon.awssdk.services.autoscalingplans.model.TagFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSource> {
    private static final SdkField<String> CLOUD_FORMATION_STACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationSource.getter(ApplicationSource::cloudFormationStackARN)).setter(ApplicationSource.setter(Builder::cloudFormationStackARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationStackARN").build()}).build();
    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ApplicationSource.getter(ApplicationSource::tagFilters)).setter(ApplicationSource.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_STACK_ARN_FIELD, TAG_FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cloudFormationStackARN;
    private final List<TagFilter> tagFilters;

    private ApplicationSource(BuilderImpl builder) {
        this.cloudFormationStackARN = builder.cloudFormationStackARN;
        this.tagFilters = builder.tagFilters;
    }

    public String cloudFormationStackARN() {
        return this.cloudFormationStackARN;
    }

    public List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationStackARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSource)) {
            return false;
        }
        ApplicationSource other = (ApplicationSource)obj;
        return Objects.equals(this.cloudFormationStackARN(), other.cloudFormationStackARN()) && Objects.equals(this.tagFilters(), other.tagFilters());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSource").add("CloudFormationStackARN", (Object)this.cloudFormationStackARN()).add("TagFilters", this.tagFilters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFormationStackARN": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationStackARN()));
            }
            case "TagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSource, T> g) {
        return obj -> g.apply((ApplicationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudFormationStackARN;
        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSource model) {
            this.cloudFormationStackARN(model.cloudFormationStackARN);
            this.tagFilters(model.tagFilters);
        }

        public final String getCloudFormationStackARN() {
            return this.cloudFormationStackARN;
        }

        @Override
        public final Builder cloudFormationStackARN(String cloudFormationStackARN) {
            this.cloudFormationStackARN = cloudFormationStackARN;
            return this;
        }

        public final void setCloudFormationStackARN(String cloudFormationStackARN) {
            this.cloudFormationStackARN = cloudFormationStackARN;
        }

        public final Collection<TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFiltersCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFiltersCopier.copyFromBuilder(tagFilters);
        }

        public ApplicationSource build() {
            return new ApplicationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSource> {
        public Builder cloudFormationStackARN(String var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder tagFilters(Consumer<TagFilter.Builder> ... var1);
    }
}

