/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification;
import software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification;
import software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior;
import software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode;
import software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior;
import software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace;
import software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration;
import software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingInstruction> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalingInstruction.getter(ScalingInstruction::serviceNamespaceAsString)).setter(ScalingInstruction.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalingInstruction.getter(ScalingInstruction::resourceId)).setter(ScalingInstruction.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalingInstruction.getter(ScalingInstruction::scalableDimensionAsString)).setter(ScalingInstruction.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(ScalingInstruction.getter(ScalingInstruction::minCapacity)).setter(ScalingInstruction.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(ScalingInstruction.getter(ScalingInstruction::maxCapacity)).setter(ScalingInstruction.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<List<TargetTrackingConfiguration>> TARGET_TRACKING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetTrackingConfigurations").getter(ScalingInstruction.getter(ScalingInstruction::targetTrackingConfigurations)).setter(ScalingInstruction.setter(Builder::targetTrackingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PredefinedLoadMetricSpecification> PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredefinedLoadMetricSpecification").getter(ScalingInstruction.getter(ScalingInstruction::predefinedLoadMetricSpecification)).setter(ScalingInstruction.setter(Builder::predefinedLoadMetricSpecification)).constructor(PredefinedLoadMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedLoadMetricSpecification").build()}).build();
    private static final SdkField<CustomizedLoadMetricSpecification> CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomizedLoadMetricSpecification").getter(ScalingInstruction.getter(ScalingInstruction::customizedLoadMetricSpecification)).setter(ScalingInstruction.setter(Builder::customizedLoadMetricSpecification)).constructor(CustomizedLoadMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedLoadMetricSpecification").build()}).build();
    private static final SdkField<Integer> SCHEDULED_ACTION_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduledActionBufferTime").getter(ScalingInstruction.getter(ScalingInstruction::scheduledActionBufferTime)).setter(ScalingInstruction.setter(Builder::scheduledActionBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionBufferTime").build()}).build();
    private static final SdkField<String> PREDICTIVE_SCALING_MAX_CAPACITY_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictiveScalingMaxCapacityBehavior").getter(ScalingInstruction.getter(ScalingInstruction::predictiveScalingMaxCapacityBehaviorAsString)).setter(ScalingInstruction.setter(Builder::predictiveScalingMaxCapacityBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingMaxCapacityBehavior").build()}).build();
    private static final SdkField<Integer> PREDICTIVE_SCALING_MAX_CAPACITY_BUFFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PredictiveScalingMaxCapacityBuffer").getter(ScalingInstruction.getter(ScalingInstruction::predictiveScalingMaxCapacityBuffer)).setter(ScalingInstruction.setter(Builder::predictiveScalingMaxCapacityBuffer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingMaxCapacityBuffer").build()}).build();
    private static final SdkField<String> PREDICTIVE_SCALING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictiveScalingMode").getter(ScalingInstruction.getter(ScalingInstruction::predictiveScalingModeAsString)).setter(ScalingInstruction.setter(Builder::predictiveScalingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingMode").build()}).build();
    private static final SdkField<String> SCALING_POLICY_UPDATE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingPolicyUpdateBehavior").getter(ScalingInstruction.getter(ScalingInstruction::scalingPolicyUpdateBehaviorAsString)).setter(ScalingInstruction.setter(Builder::scalingPolicyUpdateBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicyUpdateBehavior").build()}).build();
    private static final SdkField<Boolean> DISABLE_DYNAMIC_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableDynamicScaling").getter(ScalingInstruction.getter(ScalingInstruction::disableDynamicScaling)).setter(ScalingInstruction.setter(Builder::disableDynamicScaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableDynamicScaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, TARGET_TRACKING_CONFIGURATIONS_FIELD, PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD, SCHEDULED_ACTION_BUFFER_TIME_FIELD, PREDICTIVE_SCALING_MAX_CAPACITY_BEHAVIOR_FIELD, PREDICTIVE_SCALING_MAX_CAPACITY_BUFFER_FIELD, PREDICTIVE_SCALING_MODE_FIELD, SCALING_POLICY_UPDATE_BEHAVIOR_FIELD, DISABLE_DYNAMIC_SCALING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScalingInstruction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final List<TargetTrackingConfiguration> targetTrackingConfigurations;
    private final PredefinedLoadMetricSpecification predefinedLoadMetricSpecification;
    private final CustomizedLoadMetricSpecification customizedLoadMetricSpecification;
    private final Integer scheduledActionBufferTime;
    private final String predictiveScalingMaxCapacityBehavior;
    private final Integer predictiveScalingMaxCapacityBuffer;
    private final String predictiveScalingMode;
    private final String scalingPolicyUpdateBehavior;
    private final Boolean disableDynamicScaling;

    private ScalingInstruction(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.targetTrackingConfigurations = builder.targetTrackingConfigurations;
        this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
        this.customizedLoadMetricSpecification = builder.customizedLoadMetricSpecification;
        this.scheduledActionBufferTime = builder.scheduledActionBufferTime;
        this.predictiveScalingMaxCapacityBehavior = builder.predictiveScalingMaxCapacityBehavior;
        this.predictiveScalingMaxCapacityBuffer = builder.predictiveScalingMaxCapacityBuffer;
        this.predictiveScalingMode = builder.predictiveScalingMode;
        this.scalingPolicyUpdateBehavior = builder.scalingPolicyUpdateBehavior;
        this.disableDynamicScaling = builder.disableDynamicScaling;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final Integer minCapacity() {
        return this.minCapacity;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final boolean hasTargetTrackingConfigurations() {
        return this.targetTrackingConfigurations != null && !(this.targetTrackingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TargetTrackingConfiguration> targetTrackingConfigurations() {
        return this.targetTrackingConfigurations;
    }

    public final PredefinedLoadMetricSpecification predefinedLoadMetricSpecification() {
        return this.predefinedLoadMetricSpecification;
    }

    public final CustomizedLoadMetricSpecification customizedLoadMetricSpecification() {
        return this.customizedLoadMetricSpecification;
    }

    public final Integer scheduledActionBufferTime() {
        return this.scheduledActionBufferTime;
    }

    public final PredictiveScalingMaxCapacityBehavior predictiveScalingMaxCapacityBehavior() {
        return PredictiveScalingMaxCapacityBehavior.fromValue(this.predictiveScalingMaxCapacityBehavior);
    }

    public final String predictiveScalingMaxCapacityBehaviorAsString() {
        return this.predictiveScalingMaxCapacityBehavior;
    }

    public final Integer predictiveScalingMaxCapacityBuffer() {
        return this.predictiveScalingMaxCapacityBuffer;
    }

    public final PredictiveScalingMode predictiveScalingMode() {
        return PredictiveScalingMode.fromValue(this.predictiveScalingMode);
    }

    public final String predictiveScalingModeAsString() {
        return this.predictiveScalingMode;
    }

    public final ScalingPolicyUpdateBehavior scalingPolicyUpdateBehavior() {
        return ScalingPolicyUpdateBehavior.fromValue(this.scalingPolicyUpdateBehavior);
    }

    public final String scalingPolicyUpdateBehaviorAsString() {
        return this.scalingPolicyUpdateBehavior;
    }

    public final Boolean disableDynamicScaling() {
        return this.disableDynamicScaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTrackingConfigurations() ? this.targetTrackingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedLoadMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizedLoadMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingMaxCapacityBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingMaxCapacityBuffer());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicyUpdateBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableDynamicScaling());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingInstruction)) {
            return false;
        }
        ScalingInstruction other = (ScalingInstruction)obj;
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && this.hasTargetTrackingConfigurations() == other.hasTargetTrackingConfigurations() && Objects.equals(this.targetTrackingConfigurations(), other.targetTrackingConfigurations()) && Objects.equals(this.predefinedLoadMetricSpecification(), other.predefinedLoadMetricSpecification()) && Objects.equals(this.customizedLoadMetricSpecification(), other.customizedLoadMetricSpecification()) && Objects.equals(this.scheduledActionBufferTime(), other.scheduledActionBufferTime()) && Objects.equals(this.predictiveScalingMaxCapacityBehaviorAsString(), other.predictiveScalingMaxCapacityBehaviorAsString()) && Objects.equals(this.predictiveScalingMaxCapacityBuffer(), other.predictiveScalingMaxCapacityBuffer()) && Objects.equals(this.predictiveScalingModeAsString(), other.predictiveScalingModeAsString()) && Objects.equals(this.scalingPolicyUpdateBehaviorAsString(), other.scalingPolicyUpdateBehaviorAsString()) && Objects.equals(this.disableDynamicScaling(), other.disableDynamicScaling());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingInstruction").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("TargetTrackingConfigurations", this.hasTargetTrackingConfigurations() ? this.targetTrackingConfigurations() : null).add("PredefinedLoadMetricSpecification", (Object)this.predefinedLoadMetricSpecification()).add("CustomizedLoadMetricSpecification", (Object)this.customizedLoadMetricSpecification()).add("ScheduledActionBufferTime", (Object)this.scheduledActionBufferTime()).add("PredictiveScalingMaxCapacityBehavior", (Object)this.predictiveScalingMaxCapacityBehaviorAsString()).add("PredictiveScalingMaxCapacityBuffer", (Object)this.predictiveScalingMaxCapacityBuffer()).add("PredictiveScalingMode", (Object)this.predictiveScalingModeAsString()).add("ScalingPolicyUpdateBehavior", (Object)this.scalingPolicyUpdateBehaviorAsString()).add("DisableDynamicScaling", (Object)this.disableDynamicScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "TargetTrackingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfigurations()));
            }
            case "PredefinedLoadMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedLoadMetricSpecification()));
            }
            case "CustomizedLoadMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.customizedLoadMetricSpecification()));
            }
            case "ScheduledActionBufferTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionBufferTime()));
            }
            case "PredictiveScalingMaxCapacityBehavior": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingMaxCapacityBehaviorAsString()));
            }
            case "PredictiveScalingMaxCapacityBuffer": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingMaxCapacityBuffer()));
            }
            case "PredictiveScalingMode": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingModeAsString()));
            }
            case "ScalingPolicyUpdateBehavior": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicyUpdateBehaviorAsString()));
            }
            case "DisableDynamicScaling": {
                return Optional.ofNullable(clazz.cast(this.disableDynamicScaling()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ScalableDimension", SCALABLE_DIMENSION_FIELD);
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("TargetTrackingConfigurations", TARGET_TRACKING_CONFIGURATIONS_FIELD);
        map.put("PredefinedLoadMetricSpecification", PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD);
        map.put("CustomizedLoadMetricSpecification", CUSTOMIZED_LOAD_METRIC_SPECIFICATION_FIELD);
        map.put("ScheduledActionBufferTime", SCHEDULED_ACTION_BUFFER_TIME_FIELD);
        map.put("PredictiveScalingMaxCapacityBehavior", PREDICTIVE_SCALING_MAX_CAPACITY_BEHAVIOR_FIELD);
        map.put("PredictiveScalingMaxCapacityBuffer", PREDICTIVE_SCALING_MAX_CAPACITY_BUFFER_FIELD);
        map.put("PredictiveScalingMode", PREDICTIVE_SCALING_MODE_FIELD);
        map.put("ScalingPolicyUpdateBehavior", SCALING_POLICY_UPDATE_BEHAVIOR_FIELD);
        map.put("DisableDynamicScaling", DISABLE_DYNAMIC_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingInstruction, T> g) {
        return obj -> g.apply((ScalingInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer minCapacity;
        private Integer maxCapacity;
        private List<TargetTrackingConfiguration> targetTrackingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private PredefinedLoadMetricSpecification predefinedLoadMetricSpecification;
        private CustomizedLoadMetricSpecification customizedLoadMetricSpecification;
        private Integer scheduledActionBufferTime;
        private String predictiveScalingMaxCapacityBehavior;
        private Integer predictiveScalingMaxCapacityBuffer;
        private String predictiveScalingMode;
        private String scalingPolicyUpdateBehavior;
        private Boolean disableDynamicScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingInstruction model) {
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.targetTrackingConfigurations(model.targetTrackingConfigurations);
            this.predefinedLoadMetricSpecification(model.predefinedLoadMetricSpecification);
            this.customizedLoadMetricSpecification(model.customizedLoadMetricSpecification);
            this.scheduledActionBufferTime(model.scheduledActionBufferTime);
            this.predictiveScalingMaxCapacityBehavior(model.predictiveScalingMaxCapacityBehavior);
            this.predictiveScalingMaxCapacityBuffer(model.predictiveScalingMaxCapacityBuffer);
            this.predictiveScalingMode(model.predictiveScalingMode);
            this.scalingPolicyUpdateBehavior(model.scalingPolicyUpdateBehavior);
            this.disableDynamicScaling(model.disableDynamicScaling);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final List<TargetTrackingConfiguration.Builder> getTargetTrackingConfigurations() {
            List<TargetTrackingConfiguration.Builder> result = TargetTrackingConfigurationsCopier.copyToBuilder(this.targetTrackingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetTrackingConfigurations(Collection<TargetTrackingConfiguration.BuilderImpl> targetTrackingConfigurations) {
            this.targetTrackingConfigurations = TargetTrackingConfigurationsCopier.copyFromBuilder(targetTrackingConfigurations);
        }

        @Override
        public final Builder targetTrackingConfigurations(Collection<TargetTrackingConfiguration> targetTrackingConfigurations) {
            this.targetTrackingConfigurations = TargetTrackingConfigurationsCopier.copy(targetTrackingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingConfigurations(TargetTrackingConfiguration ... targetTrackingConfigurations) {
            this.targetTrackingConfigurations(Arrays.asList(targetTrackingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingConfigurations(Consumer<TargetTrackingConfiguration.Builder> ... targetTrackingConfigurations) {
            this.targetTrackingConfigurations(Stream.of(targetTrackingConfigurations).map(c -> (TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PredefinedLoadMetricSpecification.Builder getPredefinedLoadMetricSpecification() {
            return this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.toBuilder() : null;
        }

        public final void setPredefinedLoadMetricSpecification(PredefinedLoadMetricSpecification.BuilderImpl predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification.build() : null;
        }

        @Override
        public final Builder predefinedLoadMetricSpecification(PredefinedLoadMetricSpecification predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
            return this;
        }

        public final CustomizedLoadMetricSpecification.Builder getCustomizedLoadMetricSpecification() {
            return this.customizedLoadMetricSpecification != null ? this.customizedLoadMetricSpecification.toBuilder() : null;
        }

        public final void setCustomizedLoadMetricSpecification(CustomizedLoadMetricSpecification.BuilderImpl customizedLoadMetricSpecification) {
            this.customizedLoadMetricSpecification = customizedLoadMetricSpecification != null ? customizedLoadMetricSpecification.build() : null;
        }

        @Override
        public final Builder customizedLoadMetricSpecification(CustomizedLoadMetricSpecification customizedLoadMetricSpecification) {
            this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
            return this;
        }

        public final Integer getScheduledActionBufferTime() {
            return this.scheduledActionBufferTime;
        }

        public final void setScheduledActionBufferTime(Integer scheduledActionBufferTime) {
            this.scheduledActionBufferTime = scheduledActionBufferTime;
        }

        @Override
        public final Builder scheduledActionBufferTime(Integer scheduledActionBufferTime) {
            this.scheduledActionBufferTime = scheduledActionBufferTime;
            return this;
        }

        public final String getPredictiveScalingMaxCapacityBehavior() {
            return this.predictiveScalingMaxCapacityBehavior;
        }

        public final void setPredictiveScalingMaxCapacityBehavior(String predictiveScalingMaxCapacityBehavior) {
            this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
        }

        @Override
        public final Builder predictiveScalingMaxCapacityBehavior(String predictiveScalingMaxCapacityBehavior) {
            this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
            return this;
        }

        @Override
        public final Builder predictiveScalingMaxCapacityBehavior(PredictiveScalingMaxCapacityBehavior predictiveScalingMaxCapacityBehavior) {
            this.predictiveScalingMaxCapacityBehavior(predictiveScalingMaxCapacityBehavior == null ? null : predictiveScalingMaxCapacityBehavior.toString());
            return this;
        }

        public final Integer getPredictiveScalingMaxCapacityBuffer() {
            return this.predictiveScalingMaxCapacityBuffer;
        }

        public final void setPredictiveScalingMaxCapacityBuffer(Integer predictiveScalingMaxCapacityBuffer) {
            this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
        }

        @Override
        public final Builder predictiveScalingMaxCapacityBuffer(Integer predictiveScalingMaxCapacityBuffer) {
            this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
            return this;
        }

        public final String getPredictiveScalingMode() {
            return this.predictiveScalingMode;
        }

        public final void setPredictiveScalingMode(String predictiveScalingMode) {
            this.predictiveScalingMode = predictiveScalingMode;
        }

        @Override
        public final Builder predictiveScalingMode(String predictiveScalingMode) {
            this.predictiveScalingMode = predictiveScalingMode;
            return this;
        }

        @Override
        public final Builder predictiveScalingMode(PredictiveScalingMode predictiveScalingMode) {
            this.predictiveScalingMode(predictiveScalingMode == null ? null : predictiveScalingMode.toString());
            return this;
        }

        public final String getScalingPolicyUpdateBehavior() {
            return this.scalingPolicyUpdateBehavior;
        }

        public final void setScalingPolicyUpdateBehavior(String scalingPolicyUpdateBehavior) {
            this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
        }

        @Override
        public final Builder scalingPolicyUpdateBehavior(String scalingPolicyUpdateBehavior) {
            this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
            return this;
        }

        @Override
        public final Builder scalingPolicyUpdateBehavior(ScalingPolicyUpdateBehavior scalingPolicyUpdateBehavior) {
            this.scalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior == null ? null : scalingPolicyUpdateBehavior.toString());
            return this;
        }

        public final Boolean getDisableDynamicScaling() {
            return this.disableDynamicScaling;
        }

        public final void setDisableDynamicScaling(Boolean disableDynamicScaling) {
            this.disableDynamicScaling = disableDynamicScaling;
        }

        @Override
        public final Builder disableDynamicScaling(Boolean disableDynamicScaling) {
            this.disableDynamicScaling = disableDynamicScaling;
            return this;
        }

        public ScalingInstruction build() {
            return new ScalingInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingInstruction> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder targetTrackingConfigurations(Collection<TargetTrackingConfiguration> var1);

        public Builder targetTrackingConfigurations(TargetTrackingConfiguration ... var1);

        public Builder targetTrackingConfigurations(Consumer<TargetTrackingConfiguration.Builder> ... var1);

        public Builder predefinedLoadMetricSpecification(PredefinedLoadMetricSpecification var1);

        default public Builder predefinedLoadMetricSpecification(Consumer<PredefinedLoadMetricSpecification.Builder> predefinedLoadMetricSpecification) {
            return this.predefinedLoadMetricSpecification((PredefinedLoadMetricSpecification)((PredefinedLoadMetricSpecification.Builder)PredefinedLoadMetricSpecification.builder().applyMutation(predefinedLoadMetricSpecification)).build());
        }

        public Builder customizedLoadMetricSpecification(CustomizedLoadMetricSpecification var1);

        default public Builder customizedLoadMetricSpecification(Consumer<CustomizedLoadMetricSpecification.Builder> customizedLoadMetricSpecification) {
            return this.customizedLoadMetricSpecification((CustomizedLoadMetricSpecification)((CustomizedLoadMetricSpecification.Builder)CustomizedLoadMetricSpecification.builder().applyMutation(customizedLoadMetricSpecification)).build());
        }

        public Builder scheduledActionBufferTime(Integer var1);

        public Builder predictiveScalingMaxCapacityBehavior(String var1);

        public Builder predictiveScalingMaxCapacityBehavior(PredictiveScalingMaxCapacityBehavior var1);

        public Builder predictiveScalingMaxCapacityBuffer(Integer var1);

        public Builder predictiveScalingMode(String var1);

        public Builder predictiveScalingMode(PredictiveScalingMode var1);

        public Builder scalingPolicyUpdateBehavior(String var1);

        public Builder scalingPolicyUpdateBehavior(ScalingPolicyUpdateBehavior var1);

        public Builder disableDynamicScaling(Boolean var1);
    }
}

