/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.AutoScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPlansCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPlansResponse
extends AutoScalingPlansResponse
implements ToCopyableBuilder<Builder, DescribeScalingPlansResponse> {
    private static final SdkField<List<ScalingPlan>> SCALING_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPlans").getter(DescribeScalingPlansResponse.getter(DescribeScalingPlansResponse::scalingPlans)).setter(DescribeScalingPlansResponse.setter(Builder::scalingPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingPlansResponse.getter(DescribeScalingPlansResponse::nextToken)).setter(DescribeScalingPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLANS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScalingPlan> scalingPlans;
    private final String nextToken;

    private DescribeScalingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPlans = builder.scalingPlans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScalingPlans() {
        return this.scalingPlans != null && !(this.scalingPlans instanceof SdkAutoConstructList);
    }

    public final List<ScalingPlan> scalingPlans() {
        return this.scalingPlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPlans() ? this.scalingPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlansResponse)) {
            return false;
        }
        DescribeScalingPlansResponse other = (DescribeScalingPlansResponse)((Object)obj);
        return this.hasScalingPlans() == other.hasScalingPlans() && Objects.equals(this.scalingPlans(), other.scalingPlans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingPlansResponse").add("ScalingPlans", this.hasScalingPlans() ? this.scalingPlans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlans": {
                return Optional.ofNullable(clazz.cast(this.scalingPlans()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlansResponse, T> g) {
        return obj -> g.apply((DescribeScalingPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingPlansResponse.BuilderImpl
    implements Builder {
        private List<ScalingPlan> scalingPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlansResponse model) {
            super(model);
            this.scalingPlans(model.scalingPlans);
            this.nextToken(model.nextToken);
        }

        public final List<ScalingPlan.Builder> getScalingPlans() {
            List<ScalingPlan.Builder> result = ScalingPlansCopier.copyToBuilder(this.scalingPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPlans(Collection<ScalingPlan.BuilderImpl> scalingPlans) {
            this.scalingPlans = ScalingPlansCopier.copyFromBuilder(scalingPlans);
        }

        @Override
        public final Builder scalingPlans(Collection<ScalingPlan> scalingPlans) {
            this.scalingPlans = ScalingPlansCopier.copy(scalingPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlans(ScalingPlan ... scalingPlans) {
            this.scalingPlans(Arrays.asList(scalingPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlans(Consumer<ScalingPlan.Builder> ... scalingPlans) {
            this.scalingPlans(Stream.of(scalingPlans).map(c -> (ScalingPlan)((ScalingPlan.Builder)ScalingPlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScalingPlansResponse build() {
            return new DescribeScalingPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingPlansResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPlansResponse> {
        public Builder scalingPlans(Collection<ScalingPlan> var1);

        public Builder scalingPlans(ScalingPlan ... var1);

        public Builder scalingPlans(Consumer<ScalingPlan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

