/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension;
import software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace;
import software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration;
import software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingInstruction> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingInstruction.getter(ScalingInstruction::serviceNamespaceAsString)).setter(ScalingInstruction.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingInstruction.getter(ScalingInstruction::resourceId)).setter(ScalingInstruction.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScalingInstruction.getter(ScalingInstruction::scalableDimensionAsString)).setter(ScalingInstruction.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScalingInstruction.getter(ScalingInstruction::minCapacity)).setter(ScalingInstruction.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScalingInstruction.getter(ScalingInstruction::maxCapacity)).setter(ScalingInstruction.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<List<TargetTrackingConfiguration>> TARGET_TRACKING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScalingInstruction.getter(ScalingInstruction::targetTrackingConfigurations)).setter(ScalingInstruction.setter(Builder::targetTrackingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, TARGET_TRACKING_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final List<TargetTrackingConfiguration> targetTrackingConfigurations;

    private ScalingInstruction(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.targetTrackingConfigurations = builder.targetTrackingConfigurations;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public Integer maxCapacity() {
        return this.maxCapacity;
    }

    public List<TargetTrackingConfiguration> targetTrackingConfigurations() {
        return this.targetTrackingConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingInstruction)) {
            return false;
        }
        ScalingInstruction other = (ScalingInstruction)obj;
        return Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.targetTrackingConfigurations(), other.targetTrackingConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"ScalingInstruction").add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("TargetTrackingConfigurations", this.targetTrackingConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "TargetTrackingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingInstruction, T> g) {
        return obj -> g.apply((ScalingInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private Integer minCapacity;
        private Integer maxCapacity;
        private List<TargetTrackingConfiguration> targetTrackingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingInstruction model) {
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.targetTrackingConfigurations(model.targetTrackingConfigurations);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Collection<TargetTrackingConfiguration.Builder> getTargetTrackingConfigurations() {
            return this.targetTrackingConfigurations != null ? (Collection)this.targetTrackingConfigurations.stream().map(TargetTrackingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetTrackingConfigurations(Collection<TargetTrackingConfiguration> targetTrackingConfigurations) {
            this.targetTrackingConfigurations = TargetTrackingConfigurationsCopier.copy(targetTrackingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingConfigurations(TargetTrackingConfiguration ... targetTrackingConfigurations) {
            this.targetTrackingConfigurations(Arrays.asList(targetTrackingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTrackingConfigurations(Consumer<TargetTrackingConfiguration.Builder> ... targetTrackingConfigurations) {
            this.targetTrackingConfigurations(Stream.of(targetTrackingConfigurations).map(c -> (TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetTrackingConfigurations(Collection<TargetTrackingConfiguration.BuilderImpl> targetTrackingConfigurations) {
            this.targetTrackingConfigurations = TargetTrackingConfigurationsCopier.copyFromBuilder(targetTrackingConfigurations);
        }

        public ScalingInstruction build() {
            return new ScalingInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingInstruction> {
        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder targetTrackingConfigurations(Collection<TargetTrackingConfiguration> var1);

        public Builder targetTrackingConfigurations(TargetTrackingConfiguration ... var1);

        public Builder targetTrackingConfigurations(Consumer<TargetTrackingConfiguration.Builder> ... var1);
    }
}

