/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.autoscaling.transform.AttachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchDeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchPutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CompleteLifecycleActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateOrUpdateTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAdjustmentTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLaunchConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHookTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHooksRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeMetricCollectionTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribePoliciesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingProcessTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DisableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnterStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExecutePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExitStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RecordLifecycleActionHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ResumeProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetDesiredCapacityRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceProtectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.UpdateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAutoScalingAsyncClient
implements AutoScalingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoScalingAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "autoscaling";
    }

    @Override
    public CompletableFuture<AttachInstancesResponse> attachInstances(AttachInstancesRequest attachInstancesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachInstancesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstances").withMarshaller((Marshaller)new AttachInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachInstancesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerTargetGroupsResponse> attachLoadBalancerTargetGroups(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancerTargetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTargetGroups").withMarshaller((Marshaller)new AttachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancerTargetGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancersResponse> attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AttachLoadBalancersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancers").withMarshaller((Marshaller)new AttachLoadBalancersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)attachLoadBalancersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteScheduledActionResponse> batchDeleteScheduledAction(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchDeleteScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteScheduledAction").withMarshaller((Marshaller)new BatchDeleteScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteScheduledActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchPutScheduledUpdateGroupActionResponse> batchPutScheduledUpdateGroupAction(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BatchPutScheduledUpdateGroupActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutScheduledUpdateGroupAction").withMarshaller((Marshaller)new BatchPutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutScheduledUpdateGroupActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CompleteLifecycleActionResponse> completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CompleteLifecycleActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLifecycleAction").withMarshaller((Marshaller)new CompleteLifecycleActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeLifecycleActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAutoScalingGroupResponse> createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateAutoScalingGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoScalingGroup").withMarshaller((Marshaller)new CreateAutoScalingGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAutoScalingGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLaunchConfigurationResponse> createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLaunchConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfiguration").withMarshaller((Marshaller)new CreateLaunchConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLaunchConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateOrUpdateTagsResponse> createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateOrUpdateTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOrUpdateTags").withMarshaller((Marshaller)new CreateOrUpdateTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createOrUpdateTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAutoScalingGroupResponse> deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAutoScalingGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoScalingGroup").withMarshaller((Marshaller)new DeleteAutoScalingGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAutoScalingGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLaunchConfigurationResponse> deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLaunchConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfiguration").withMarshaller((Marshaller)new DeleteLaunchConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLaunchConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLifecycleHookResponse> deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLifecycleHookResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLifecycleHook").withMarshaller((Marshaller)new DeleteLifecycleHookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLifecycleHookRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteNotificationConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationConfiguration").withMarshaller((Marshaller)new DeleteNotificationConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNotificationConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeletePolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withMarshaller((Marshaller)new DeletePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteScheduledActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteScheduledActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAdjustmentTypesResponse> describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAdjustmentTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAdjustmentTypes").withMarshaller((Marshaller)new DescribeAdjustmentTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAdjustmentTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAutoScalingGroupsResponse> describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingGroups").withMarshaller((Marshaller)new DescribeAutoScalingGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAutoScalingGroupsPublisher describeAutoScalingGroupsPaginator(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return new DescribeAutoScalingGroupsPublisher(this, this.applyPaginatorUserAgent(describeAutoScalingGroupsRequest));
    }

    @Override
    public CompletableFuture<DescribeAutoScalingInstancesResponse> describeAutoScalingInstances(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingInstancesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingInstances").withMarshaller((Marshaller)new DescribeAutoScalingInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingInstancesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAutoScalingInstancesPublisher describeAutoScalingInstancesPaginator(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        return new DescribeAutoScalingInstancesPublisher(this, this.applyPaginatorUserAgent(describeAutoScalingInstancesRequest));
    }

    @Override
    public CompletableFuture<DescribeAutoScalingNotificationTypesResponse> describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAutoScalingNotificationTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoScalingNotificationTypes").withMarshaller((Marshaller)new DescribeAutoScalingNotificationTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoScalingNotificationTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLaunchConfigurationsResponse> describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLaunchConfigurationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurations").withMarshaller((Marshaller)new DescribeLaunchConfigurationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLaunchConfigurationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeLaunchConfigurationsPublisher describeLaunchConfigurationsPaginator(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        return new DescribeLaunchConfigurationsPublisher(this, this.applyPaginatorUserAgent(describeLaunchConfigurationsRequest));
    }

    @Override
    public CompletableFuture<DescribeLifecycleHookTypesResponse> describeLifecycleHookTypes(DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHookTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHookTypes").withMarshaller((Marshaller)new DescribeLifecycleHookTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHookTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLifecycleHooksResponse> describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLifecycleHooksResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleHooks").withMarshaller((Marshaller)new DescribeLifecycleHooksRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleHooksRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancerTargetGroupsResponse> describeLoadBalancerTargetGroups(DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerTargetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerTargetGroups").withMarshaller((Marshaller)new DescribeLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerTargetGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMetricCollectionTypesResponse> describeMetricCollectionTypes(DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeMetricCollectionTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricCollectionTypes").withMarshaller((Marshaller)new DescribeMetricCollectionTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricCollectionTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNotificationConfigurationsResponse> describeNotificationConfigurations(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeNotificationConfigurationsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationConfigurations").withMarshaller((Marshaller)new DescribeNotificationConfigurationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNotificationConfigurationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeNotificationConfigurationsPublisher describeNotificationConfigurationsPaginator(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        return new DescribeNotificationConfigurationsPublisher(this, this.applyPaginatorUserAgent(describeNotificationConfigurationsRequest));
    }

    @Override
    public CompletableFuture<DescribePoliciesResponse> describePolicies(DescribePoliciesRequest describePoliciesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePoliciesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePolicies").withMarshaller((Marshaller)new DescribePoliciesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePoliciesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribePoliciesPublisher describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest) {
        return new DescribePoliciesPublisher(this, this.applyPaginatorUserAgent(describePoliciesRequest));
    }

    @Override
    public CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingActivitiesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingActivitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        return new DescribeScalingActivitiesPublisher(this, this.applyPaginatorUserAgent(describeScalingActivitiesRequest));
    }

    @Override
    public CompletableFuture<DescribeScalingProcessTypesResponse> describeScalingProcessTypes(DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingProcessTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingProcessTypes").withMarshaller((Marshaller)new DescribeScalingProcessTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingProcessTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScheduledActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScheduledActionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeScheduledActionsPublisher describeScheduledActionsPaginator(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        return new DescribeScheduledActionsPublisher(this, this.applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeTagsPublisher describeTagsPaginator(DescribeTagsRequest describeTagsRequest) {
        return new DescribeTagsPublisher(this, this.applyPaginatorUserAgent(describeTagsRequest));
    }

    @Override
    public CompletableFuture<DescribeTerminationPolicyTypesResponse> describeTerminationPolicyTypes(DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTerminationPolicyTypesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTerminationPolicyTypes").withMarshaller((Marshaller)new DescribeTerminationPolicyTypesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTerminationPolicyTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachInstancesResponse> detachInstances(DetachInstancesRequest detachInstancesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachInstancesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstances").withMarshaller((Marshaller)new DetachInstancesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachInstancesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachLoadBalancerTargetGroupsResponse> detachLoadBalancerTargetGroups(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancerTargetGroupsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancerTargetGroups").withMarshaller((Marshaller)new DetachLoadBalancerTargetGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancerTargetGroupsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachLoadBalancersResponse> detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DetachLoadBalancersResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachLoadBalancers").withMarshaller((Marshaller)new DetachLoadBalancersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detachLoadBalancersRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableMetricsCollectionResponse> disableMetricsCollection(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableMetricsCollectionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableMetricsCollection").withMarshaller((Marshaller)new DisableMetricsCollectionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableMetricsCollectionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableMetricsCollectionResponse> enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableMetricsCollectionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableMetricsCollection").withMarshaller((Marshaller)new EnableMetricsCollectionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableMetricsCollectionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnterStandbyResponse> enterStandby(EnterStandbyRequest enterStandbyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnterStandbyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnterStandby").withMarshaller((Marshaller)new EnterStandbyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enterStandbyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecutePolicyResponse> executePolicy(ExecutePolicyRequest executePolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExecutePolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecutePolicy").withMarshaller((Marshaller)new ExecutePolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executePolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExitStandbyResponse> exitStandby(ExitStandbyRequest exitStandbyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ExitStandbyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExitStandby").withMarshaller((Marshaller)new ExitStandbyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exitStandbyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutLifecycleHookResponse> putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutLifecycleHookResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleHook").withMarshaller((Marshaller)new PutLifecycleHookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLifecycleHookRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutNotificationConfigurationResponse> putNotificationConfiguration(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutNotificationConfigurationResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutNotificationConfiguration").withMarshaller((Marshaller)new PutNotificationConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putNotificationConfigurationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScalingPolicyResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScalingPolicyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutScheduledUpdateGroupActionResponse> putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutScheduledUpdateGroupActionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledUpdateGroupAction").withMarshaller((Marshaller)new PutScheduledUpdateGroupActionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putScheduledUpdateGroupActionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RecordLifecycleActionHeartbeatResponse> recordLifecycleActionHeartbeat(RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RecordLifecycleActionHeartbeatResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RecordLifecycleActionHeartbeat").withMarshaller((Marshaller)new RecordLifecycleActionHeartbeatRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)recordLifecycleActionHeartbeatRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResumeProcessesResponse> resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResumeProcessesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeProcesses").withMarshaller((Marshaller)new ResumeProcessesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeProcessesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetDesiredCapacityResponse> setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetDesiredCapacityResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetDesiredCapacity").withMarshaller((Marshaller)new SetDesiredCapacityRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setDesiredCapacityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetInstanceHealthResponse> setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceHealthResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceHealth").withMarshaller((Marshaller)new SetInstanceHealthRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceHealthRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetInstanceProtectionResponse> setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetInstanceProtectionResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetInstanceProtection").withMarshaller((Marshaller)new SetInstanceProtectionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setInstanceProtectionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SuspendProcessesResponse> suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SuspendProcessesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("SuspendProcesses").withMarshaller((Marshaller)new SuspendProcessesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)suspendProcessesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TerminateInstanceInAutoScalingGroupResponse> terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TerminateInstanceInAutoScalingGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateInstanceInAutoScalingGroup").withMarshaller((Marshaller)new TerminateInstanceInAutoScalingGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateInstanceInAutoScalingGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAutoScalingGroupResponse> updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAutoScalingGroupResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAutoScalingGroup").withMarshaller((Marshaller)new UpdateAutoScalingGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAutoScalingGroupRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ScalingActivityInProgress").exceptionBuilderSupplier(ScalingActivityInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExists").exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceContention").exceptionBuilderSupplier(ResourceContentionException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleFailure").exceptionBuilderSupplier(ServiceLinkedRoleFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AutoScalingException::builder).build();
    }

    private <T extends AutoScalingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.50").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AutoScalingRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

