/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.InstanceRequirements;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(LaunchTemplateOverrides.getter(LaunchTemplateOverrides::instanceType)).setter(LaunchTemplateOverrides.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeightedCapacity").getter(LaunchTemplateOverrides.getter(LaunchTemplateOverrides::weightedCapacity)).setter(LaunchTemplateOverrides.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateSpecification").getter(LaunchTemplateOverrides.getter(LaunchTemplateOverrides::launchTemplateSpecification)).setter(LaunchTemplateOverrides.setter(Builder::launchTemplateSpecification)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification").build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(LaunchTemplateOverrides.getter(LaunchTemplateOverrides::instanceRequirements)).setter(LaunchTemplateOverrides.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(LaunchTemplateOverrides.getter(LaunchTemplateOverrides::imageId)).setter(LaunchTemplateOverrides.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, WEIGHTED_CAPACITY_FIELD, LAUNCH_TEMPLATE_SPECIFICATION_FIELD, INSTANCE_REQUIREMENTS_FIELD, IMAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchTemplateOverrides.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String weightedCapacity;
    private final LaunchTemplateSpecification launchTemplateSpecification;
    private final InstanceRequirements instanceRequirements;
    private final String imageId;

    private LaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.instanceRequirements = builder.instanceRequirements;
        this.imageId = builder.imageId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String weightedCapacity() {
        return this.weightedCapacity;
    }

    public final LaunchTemplateSpecification launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public final String imageId() {
        return this.imageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateOverrides)) {
            return false;
        }
        LaunchTemplateOverrides other = (LaunchTemplateOverrides)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.imageId(), other.imageId());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateOverrides").add("InstanceType", (Object)this.instanceType()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("InstanceRequirements", (Object)this.instanceRequirements()).add("ImageId", (Object)this.imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        map.put("LaunchTemplateSpecification", LAUNCH_TEMPLATE_SPECIFICATION_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateOverrides, T> g) {
        return obj -> g.apply((LaunchTemplateOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String weightedCapacity;
        private LaunchTemplateSpecification launchTemplateSpecification;
        private InstanceRequirements instanceRequirements;
        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateOverrides model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.instanceRequirements(model.instanceRequirements);
            this.imageId(model.imageId);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(LaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public LaunchTemplateOverrides build() {
            return new LaunchTemplateOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateOverrides> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(String var1);

        public Builder launchTemplateSpecification(LaunchTemplateSpecification var1);

        default public Builder launchTemplateSpecification(Consumer<LaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder imageId(String var1);
    }
}

