/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchInstancesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<LaunchInstancesResponse.Builder, LaunchInstancesResponse> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(LaunchInstancesResponse::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(LaunchInstancesResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<List<InstanceCollection>> INSTANCES_FIELD = SdkField
            .<List<InstanceCollection>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(LaunchInstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceCollection> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceCollection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchInstancesError>> ERRORS_FIELD = SdkField
            .<List<LaunchInstancesError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(LaunchInstancesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchInstancesError> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchInstancesError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            CLIENT_TOKEN_FIELD, INSTANCES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String autoScalingGroupName;

    private final String clientToken;

    private final List<InstanceCollection> instances;

    private final List<LaunchInstancesError> errors;

    private LaunchInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.clientToken = builder.clientToken;
        this.instances = builder.instances;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The name of the Auto Scaling group where the instances were launched.
     * </p>
     * 
     * @return The name of the Auto Scaling group where the instances were launched.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The idempotency token used for the request, either customer-specified or auto-generated.
     * </p>
     * 
     * @return The idempotency token used for the request, either customer-specified or auto-generated.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of successfully launched instances including details such as instance type, Availability Zone, subnet,
     * lifecycle state, and instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return A list of successfully launched instances including details such as instance type, Availability Zone,
     *         subnet, lifecycle state, and instance IDs.
     */
    public final List<InstanceCollection> instances() {
        return instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors encountered during the launch attempt including details about failed instance launches with
     * their corresponding error codes and messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors encountered during the launch attempt including details about failed instance launches
     *         with their corresponding error codes and messages.
     */
    public final List<LaunchInstancesError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchInstancesResponse)) {
            return false;
        }
        LaunchInstancesResponse other = (LaunchInstancesResponse) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(clientToken(), other.clientToken()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchInstancesResponse").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ClientToken", clientToken()).add("Instances", hasInstances() ? instances() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchInstancesResponse, T> g) {
        return obj -> g.apply((LaunchInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AutoScalingResponse.Builder, SdkPojo, CopyableBuilder<Builder, LaunchInstancesResponse> {
        /**
         * <p>
         * The name of the Auto Scaling group where the instances were launched.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group where the instances were launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The idempotency token used for the request, either customer-specified or auto-generated.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used for the request, either customer-specified or auto-generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of successfully launched instances including details such as instance type, Availability Zone, subnet,
         * lifecycle state, and instance IDs.
         * </p>
         * 
         * @param instances
         *        A list of successfully launched instances including details such as instance type, Availability Zone,
         *        subnet, lifecycle state, and instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceCollection> instances);

        /**
         * <p>
         * A list of successfully launched instances including details such as instance type, Availability Zone, subnet,
         * lifecycle state, and instance IDs.
         * </p>
         * 
         * @param instances
         *        A list of successfully launched instances including details such as instance type, Availability Zone,
         *        subnet, lifecycle state, and instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceCollection... instances);

        /**
         * <p>
         * A list of successfully launched instances including details such as instance type, Availability Zone, subnet,
         * lifecycle state, and instance IDs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.InstanceCollection.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.InstanceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.InstanceCollection.Builder#build()} is called
         * immediately and its result is passed to {@link #instances(List<InstanceCollection>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.InstanceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<InstanceCollection>)
         */
        Builder instances(Consumer<InstanceCollection.Builder>... instances);

        /**
         * <p>
         * A list of errors encountered during the launch attempt including details about failed instance launches with
         * their corresponding error codes and messages.
         * </p>
         * 
         * @param errors
         *        A list of errors encountered during the launch attempt including details about failed instance
         *        launches with their corresponding error codes and messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<LaunchInstancesError> errors);

        /**
         * <p>
         * A list of errors encountered during the launch attempt including details about failed instance launches with
         * their corresponding error codes and messages.
         * </p>
         * 
         * @param errors
         *        A list of errors encountered during the launch attempt including details about failed instance
         *        launches with their corresponding error codes and messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(LaunchInstancesError... errors);

        /**
         * <p>
         * A list of errors encountered during the launch attempt including details about failed instance launches with
         * their corresponding error codes and messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.autoscaling.model.LaunchInstancesError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.autoscaling.model.LaunchInstancesError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.autoscaling.model.LaunchInstancesError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<LaunchInstancesError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.autoscaling.model.LaunchInstancesError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<LaunchInstancesError>)
         */
        Builder errors(Consumer<LaunchInstancesError.Builder>... errors);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String clientToken;

        private List<InstanceCollection> instances = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchInstancesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchInstancesResponse model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            clientToken(model.clientToken);
            instances(model.instances);
            errors(model.errors);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<InstanceCollection.Builder> getInstances() {
            List<InstanceCollection.Builder> result = InstanceCollectionsCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<InstanceCollection.BuilderImpl> instances) {
            this.instances = InstanceCollectionsCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<InstanceCollection> instances) {
            this.instances = InstanceCollectionsCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceCollection... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceCollection.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceCollection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchInstancesError.Builder> getErrors() {
            List<LaunchInstancesError.Builder> result = LaunchInstancesErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<LaunchInstancesError.BuilderImpl> errors) {
            this.errors = LaunchInstancesErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<LaunchInstancesError> errors) {
            this.errors = LaunchInstancesErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(LaunchInstancesError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<LaunchInstancesError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> LaunchInstancesError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LaunchInstancesResponse build() {
            return new LaunchInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
