/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountLimitsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<Integer> MAX_NUMBER_OF_AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::maxNumberOfAutoScalingGroups)).setter(DescribeAccountLimitsResponse.setter(Builder::maxNumberOfAutoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfAutoScalingGroups").build()}).build();
    private static final SdkField<Integer> MAX_NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::maxNumberOfLaunchConfigurations)).setter(DescribeAccountLimitsResponse.setter(Builder::maxNumberOfLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfLaunchConfigurations").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::numberOfAutoScalingGroups)).setter(DescribeAccountLimitsResponse.setter(Builder::numberOfAutoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAutoScalingGroups").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::numberOfLaunchConfigurations)).setter(DescribeAccountLimitsResponse.setter(Builder::numberOfLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLaunchConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_NUMBER_OF_AUTO_SCALING_GROUPS_FIELD, MAX_NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD, NUMBER_OF_AUTO_SCALING_GROUPS_FIELD, NUMBER_OF_LAUNCH_CONFIGURATIONS_FIELD));
    private final Integer maxNumberOfAutoScalingGroups;
    private final Integer maxNumberOfLaunchConfigurations;
    private final Integer numberOfAutoScalingGroups;
    private final Integer numberOfLaunchConfigurations;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.maxNumberOfAutoScalingGroups = builder.maxNumberOfAutoScalingGroups;
        this.maxNumberOfLaunchConfigurations = builder.maxNumberOfLaunchConfigurations;
        this.numberOfAutoScalingGroups = builder.numberOfAutoScalingGroups;
        this.numberOfLaunchConfigurations = builder.numberOfLaunchConfigurations;
    }

    public Integer maxNumberOfAutoScalingGroups() {
        return this.maxNumberOfAutoScalingGroups;
    }

    public Integer maxNumberOfLaunchConfigurations() {
        return this.maxNumberOfLaunchConfigurations;
    }

    public Integer numberOfAutoScalingGroups() {
        return this.numberOfAutoScalingGroups;
    }

    public Integer numberOfLaunchConfigurations() {
        return this.numberOfLaunchConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfLaunchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLaunchConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        return Objects.equals(this.maxNumberOfAutoScalingGroups(), other.maxNumberOfAutoScalingGroups()) && Objects.equals(this.maxNumberOfLaunchConfigurations(), other.maxNumberOfLaunchConfigurations()) && Objects.equals(this.numberOfAutoScalingGroups(), other.numberOfAutoScalingGroups()) && Objects.equals(this.numberOfLaunchConfigurations(), other.numberOfLaunchConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountLimitsResponse").add("MaxNumberOfAutoScalingGroups", (Object)this.maxNumberOfAutoScalingGroups()).add("MaxNumberOfLaunchConfigurations", (Object)this.maxNumberOfLaunchConfigurations()).add("NumberOfAutoScalingGroups", (Object)this.numberOfAutoScalingGroups()).add("NumberOfLaunchConfigurations", (Object)this.numberOfLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxNumberOfAutoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfAutoScalingGroups()));
            }
            case "MaxNumberOfLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfLaunchConfigurations()));
            }
            case "NumberOfAutoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.numberOfAutoScalingGroups()));
            }
            case "NumberOfLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.numberOfLaunchConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private Integer maxNumberOfAutoScalingGroups;
        private Integer maxNumberOfLaunchConfigurations;
        private Integer numberOfAutoScalingGroups;
        private Integer numberOfLaunchConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            this.maxNumberOfAutoScalingGroups(model.maxNumberOfAutoScalingGroups);
            this.maxNumberOfLaunchConfigurations(model.maxNumberOfLaunchConfigurations);
            this.numberOfAutoScalingGroups(model.numberOfAutoScalingGroups);
            this.numberOfLaunchConfigurations(model.numberOfLaunchConfigurations);
        }

        public final Integer getMaxNumberOfAutoScalingGroups() {
            return this.maxNumberOfAutoScalingGroups;
        }

        @Override
        public final Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
            return this;
        }

        public final void setMaxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
        }

        public final Integer getMaxNumberOfLaunchConfigurations() {
            return this.maxNumberOfLaunchConfigurations;
        }

        @Override
        public final Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
            return this;
        }

        public final void setMaxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
        }

        public final Integer getNumberOfAutoScalingGroups() {
            return this.numberOfAutoScalingGroups;
        }

        @Override
        public final Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
            return this;
        }

        public final void setNumberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
        }

        public final Integer getNumberOfLaunchConfigurations() {
            return this.numberOfLaunchConfigurations;
        }

        @Override
        public final Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
            return this;
        }

        public final void setNumberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder maxNumberOfAutoScalingGroups(Integer var1);

        public Builder maxNumberOfLaunchConfigurations(Integer var1);

        public Builder numberOfAutoScalingGroups(Integer var1);

        public Builder numberOfLaunchConfigurations(Integer var1);
    }
}

