/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficSourcesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeTrafficSourcesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DescribeTrafficSourcesRequest.getter(DescribeTrafficSourcesRequest::autoScalingGroupName)).setter(DescribeTrafficSourcesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> TRAFFIC_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficSourceType").getter(DescribeTrafficSourcesRequest.getter(DescribeTrafficSourcesRequest::trafficSourceType)).setter(DescribeTrafficSourcesRequest.setter(Builder::trafficSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficSourceType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTrafficSourcesRequest.getter(DescribeTrafficSourcesRequest::nextToken)).setter(DescribeTrafficSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeTrafficSourcesRequest.getter(DescribeTrafficSourcesRequest::maxRecords)).setter(DescribeTrafficSourcesRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, TRAFFIC_SOURCE_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrafficSourcesRequest.memberNameToFieldInitializer();
    private final String autoScalingGroupName;
    private final String trafficSourceType;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeTrafficSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.trafficSourceType = builder.trafficSourceType;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String trafficSourceType() {
        return this.trafficSourceType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficSourcesRequest)) {
            return false;
        }
        DescribeTrafficSourcesRequest other = (DescribeTrafficSourcesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.trafficSourceType(), other.trafficSourceType()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrafficSourcesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TrafficSourceType", (Object)this.trafficSourceType()).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "TrafficSourceType": {
                return Optional.ofNullable(clazz.cast(this.trafficSourceType()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("TrafficSourceType", TRAFFIC_SOURCE_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficSourcesRequest, T> g) {
        return obj -> g.apply((DescribeTrafficSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String trafficSourceType;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficSourcesRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.trafficSourceType(model.trafficSourceType);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getTrafficSourceType() {
            return this.trafficSourceType;
        }

        public final void setTrafficSourceType(String trafficSourceType) {
            this.trafficSourceType = trafficSourceType;
        }

        @Override
        public final Builder trafficSourceType(String trafficSourceType) {
            this.trafficSourceType = trafficSourceType;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrafficSourcesRequest build() {
            return new DescribeTrafficSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficSourcesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder trafficSourceType(String var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

