/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledActionNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteScheduledActionRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, BatchDeleteScheduledActionRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(BatchDeleteScheduledActionRequest.getter(BatchDeleteScheduledActionRequest::autoScalingGroupName)).setter(BatchDeleteScheduledActionRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> SCHEDULED_ACTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledActionNames").getter(BatchDeleteScheduledActionRequest.getter(BatchDeleteScheduledActionRequest::scheduledActionNames)).setter(BatchDeleteScheduledActionRequest.setter(Builder::scheduledActionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, SCHEDULED_ACTION_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteScheduledActionRequest.memberNameToFieldInitializer();
    private final String autoScalingGroupName;
    private final List<String> scheduledActionNames;

    private BatchDeleteScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionNames = builder.scheduledActionNames;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final boolean hasScheduledActionNames() {
        return this.scheduledActionNames != null && !(this.scheduledActionNames instanceof SdkAutoConstructList);
    }

    public final List<String> scheduledActionNames() {
        return this.scheduledActionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledActionNames() ? this.scheduledActionNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteScheduledActionRequest)) {
            return false;
        }
        BatchDeleteScheduledActionRequest other = (BatchDeleteScheduledActionRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && this.hasScheduledActionNames() == other.hasScheduledActionNames() && Objects.equals(this.scheduledActionNames(), other.scheduledActionNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteScheduledActionRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScheduledActionNames", this.hasScheduledActionNames() ? this.scheduledActionNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledActionNames": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
        map.put("ScheduledActionNames", SCHEDULED_ACTION_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteScheduledActionRequest, T> g) {
        return obj -> g.apply((BatchDeleteScheduledActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scheduledActionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteScheduledActionRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledActionNames(model.scheduledActionNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getScheduledActionNames() {
            if (this.scheduledActionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduledActionNames;
        }

        public final void setScheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
        }

        @Override
        public final Builder scheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActionNames(String ... scheduledActionNames) {
            this.scheduledActionNames(Arrays.asList(scheduledActionNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteScheduledActionRequest build() {
            return new BatchDeleteScheduledActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteScheduledActionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionNames(Collection<String> var1);

        public Builder scheduledActionNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

